/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import moa.classifiers.Classifier;
import moa.core.ObjectRepository;
import moa.evaluation.ClassificationPerformanceEvaluator;
import moa.evaluation.LearningEvaluation;
import moa.options.ClassOption;
import moa.options.FileOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;
import weka.core.Instance;
import weka.core.Utils;

public class EvaluateModel
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption modelOption = new ClassOption("model", 'm', "Classifier to evaluate.", Classifier.class, "LearnModel");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to evaluate on.", InstanceStream.class, "generators.RandomTreeGenerator");
    public ClassOption evaluatorOption = new ClassOption("evaluator", 'e', "Classification performance evaluation method.", ClassificationPerformanceEvaluator.class, "BasicClassificationPerformanceEvaluator");
    public IntOption maxInstancesOption = new IntOption("maxInstances", 'i', "Maximum number of instances to test.", 1000000, 0, Integer.MAX_VALUE);
    public FileOption outputPredictionFileOption = new FileOption("outputPredictionFile", 'o', "File to append output predictions to.", null, "pred", true);

    @Override
    public String getPurposeString() {
        return "Evaluates a static model on a stream.";
    }

    public EvaluateModel() {
    }

    public EvaluateModel(Classifier model, InstanceStream stream, ClassificationPerformanceEvaluator evaluator, int maxInstances) {
        this.modelOption.setCurrentObject(model);
        this.streamOption.setCurrentObject(stream);
        this.evaluatorOption.setCurrentObject(evaluator);
        this.maxInstancesOption.setValue(maxInstances);
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningEvaluation.class;
    }

    @Override
    public Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        Classifier model = (Classifier)this.getPreparedClassOption(this.modelOption);
        InstanceStream stream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        ClassificationPerformanceEvaluator evaluator = (ClassificationPerformanceEvaluator)this.getPreparedClassOption(this.evaluatorOption);
        int maxInstances = this.maxInstancesOption.getValue();
        long instancesProcessed = 0L;
        monitor.setCurrentActivity("Evaluating model...", -1.0);
        File outputPredictionFile = this.outputPredictionFileOption.getFile();
        PrintStream outputPredictionResultStream = null;
        if (outputPredictionFile != null) {
            try {
                outputPredictionResultStream = outputPredictionFile.exists() ? new PrintStream(new FileOutputStream(outputPredictionFile, true), true) : new PrintStream(new FileOutputStream(outputPredictionFile), true);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to open prediction result file: " + outputPredictionFile, ex);
            }
        }
        while (stream.hasMoreInstances() && (maxInstances < 0 || instancesProcessed < (long)maxInstances)) {
            Instance testInst = (Instance)stream.nextInstance().copy();
            int trueClass = (int)testInst.classValue();
            double[] prediction = model.getVotesForInstance(testInst);
            if (outputPredictionFile != null) {
                outputPredictionResultStream.println(Utils.maxIndex((double[])prediction) + "," + trueClass);
            }
            evaluator.addResult(testInst, prediction);
            if (++instancesProcessed % 10L != 0L) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            if (maxInstances > 0) {
                long maxRemaining = (long)maxInstances - instancesProcessed;
                if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                    estimatedRemainingInstances = maxRemaining;
                }
            }
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)instancesProcessed / (double)(instancesProcessed + estimatedRemainingInstances));
            if (!monitor.resultPreviewRequested()) continue;
            monitor.setLatestResultPreview(new LearningEvaluation(evaluator.getPerformanceMeasurements()));
        }
        if (outputPredictionResultStream != null) {
            outputPredictionResultStream.close();
        }
        return new LearningEvaluation(evaluator.getPerformanceMeasurements());
    }
}

