/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;

public class SpreadSheetAddSumColumn
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = 1320593539567099350L;
    protected Range m_Rows;

    public String globalInfo() {
        return "Adds a column with 'sum' formulas for the specified rows.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rows", "rows", (Object)new Range("first-last"));
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The range of rows to add the 'sum' formula for; " + this.m_Rows.getExample();
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        this.m_Rows.setMax(result.getRowCount());
        int[] rows = this.m_Rows.getIntIndices();
        result.insertColumn(result.getColumnCount(), "Sum");
        for (int i = 0; i < rows.length; ++i) {
            String from = SpreadSheet.getCellPosition((int)rows[i], (int)0);
            String to = SpreadSheet.getCellPosition((int)rows[i], (int)(result.getColumnCount() - 2));
            DataRow row = result.getRow(rows[i]);
            row.addCell(result.getColumnCount() - 1).setContent("=SUM(" + from + ":" + to + ")");
        }
        return result;
    }
}

