/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.core.Index;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import java.util.ArrayList;
import java.util.Iterator;

public class SingleCell
extends AbstractCellFinder {
    private static final long serialVersionUID = 7552127288975155281L;
    protected Index m_Row;
    protected Index m_Column;

    public String globalInfo() {
        return "Simple locator that just locates a single cell.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Index("first"));
        this.m_OptionManager.add("column", "column", (Object)new Index("first"));
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row to locate.";
    }

    public void setColumn(Index value) {
        this.m_Column = value;
        this.reset();
    }

    public Index getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column to locate.";
    }

    @Override
    protected Iterator<CellLocation> doFindCells(SpreadSheet sheet) {
        ArrayList<CellLocation> result = new ArrayList<CellLocation>();
        this.m_Row.setMax(sheet.getRowCount());
        this.m_Column.setMax(sheet.getColumnCount());
        int row = this.m_Row.getIntIndex();
        int col = this.m_Column.getIntIndex();
        if (row != -1 && col != -1) {
            result.add(new CellLocation(row, col));
        }
        return result.iterator();
    }
}

