/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.columnfinder;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import java.util.HashSet;

public abstract class AbstractColumnFinder
extends AbstractOptionHandler
implements ColumnFinder,
ShallowCopySupporter<ColumnFinder> {
    private static final long serialVersionUID = 3871603719188736704L;

    protected void check(SpreadSheet data) {
        if (data == null) {
            throw new IllegalArgumentException("No data provided!");
        }
    }

    protected abstract int[] doFindColumns(SpreadSheet var1);

    @Override
    public int[] findColumns(SpreadSheet data) {
        this.check(data);
        return this.doFindColumns(data);
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)this).compareTo(OptionUtils.getCommandLine((Object)((ColumnFinder)o)));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public ColumnFinder shallowCopy() {
        return this.shallowCopy(false);
    }

    public ColumnFinder shallowCopy(boolean expand) {
        return (ColumnFinder)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public static String[] getColumnFinders() {
        return ClassLister.getSingleton().getClassnames(ColumnFinder.class);
    }

    public static ColumnFinder forName(String classname, String[] options) {
        ColumnFinder result;
        try {
            result = (ColumnFinder)OptionUtils.forName(ColumnFinder.class, (String)classname, (String[])options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static ColumnFinder forCommandLine(String cmdline) {
        return (ColumnFinder)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }

    public static HashSet<Integer> arrayToHashSet(int[] indices) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int index : indices) {
            result.add(index);
        }
        return result;
    }

    public static SpreadSheet filter(SpreadSheet input, ColumnFinder finder) {
        int i;
        int[] indices = finder.findColumns(input);
        SpreadSheet result = input.getHeader();
        HeaderRow header = result.getHeaderRow();
        header.clear();
        for (i = 0; i < indices.length; ++i) {
            header.addCell("" + indices[i]).setContent(input.getHeaderRow().getCell(indices[i]).getContent());
        }
        for (int n = 0; n < input.getRowCount(); ++n) {
            DataRow rowIn = input.getRow(n);
            DataRow rowOut = result.addRow();
            for (i = 0; i < indices.length; ++i) {
                if (!rowIn.hasCell(indices[i])) continue;
                rowOut.addCell(i).setContent(rowIn.getContent(indices[i]));
            }
        }
        return result;
    }
}

