/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.sink.AbstractFileWriter;
import java.io.File;

public class SpreadSheetFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 393925191813730213L;
    protected AbstractSpreadSheetWriter m_Writer;

    public String globalInfo() {
        return "Actor that writes SpreadSheet objects to files.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new CsvSpreadSheetWriter());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("writer");
        if (variable != null) {
            return variable;
        }
        if (this.m_Writer != null) {
            return this.m_Writer.getClass().getName();
        }
        return null;
    }

    protected PlaceholderFile getDefaultOutputFile() {
        return new PlaceholderFile("${TMP}/out.csv");
    }

    public String outputFileTipText() {
        return "The name of the output file.";
    }

    public void setWriter(AbstractSpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractSpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer for storing the spreadsheet.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        if (!this.m_Writer.write(sheet, (File)this.m_OutputFile)) {
            result = "Problems writing spreadsheet to '" + this.m_OutputFile + "'!";
        }
        return result;
    }
}

