/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.control.StorageName;
import adams.flow.core.MissingLookUpKey;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.transformer.LookUpInit;
import java.util.HashMap;

public class LookUp
extends AbstractSource {
    private static final long serialVersionUID = -4888807180866059350L;
    protected StorageName m_StorageName;
    protected String m_Key;
    protected MissingLookUpKey m_MissingKey;
    protected String m_MissingValue;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Forwards the value associated with the given key, using the specified lookup table from internal storage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
        this.m_OptionManager.add("key", "key", (Object)"");
        this.m_OptionManager.add("missing-key", "missingKey", (Object)MissingLookUpKey.NO_OUTPUT);
        this.m_OptionManager.add("missing-value", "missingValue", (Object)"???");
    }

    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public String getQuickInfo() {
        String result = "storage: ";
        String variable = this.getOptionManager().getVariableForProperty("storageName");
        result = variable != null ? result + variable : result + this.m_StorageName.getValue();
        result = result + ", key: ";
        variable = this.getOptionManager().getVariableForProperty("key");
        result = variable != null ? result + variable : result + this.m_Key;
        result = result + ", missing: ";
        variable = this.getOptionManager().getVariableForProperty("missingKey");
        result = variable != null ? result + variable : result + (Object)((Object)this.m_MissingKey);
        result = result + ", value: ";
        variable = this.getOptionManager().getVariableForProperty("missingValue");
        result = variable != null ? result + variable : result + this.m_MissingValue;
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the lookup table in the internal storage.";
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The key of the value to output.";
    }

    public void setMissingKey(MissingLookUpKey value) {
        this.m_MissingKey = value;
        this.reset();
    }

    public MissingLookUpKey getMissingKey() {
        return this.m_MissingKey;
    }

    public String missingKeyTipText() {
        return "The behavior in case a lookup key is missing (ie not found in the lookup table).";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The value to forward if the missing key behavior is " + (Object)((Object)MissingLookUpKey.OUTPUT_MISSING_VALUE) + ".";
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            HashMap lookup = (HashMap)this.getStorageHandler().getStorage().get(this.m_StorageName);
            if (lookup.containsKey(this.m_Key)) {
                String value = (String)lookup.get(this.m_Key);
                if (this.isDebugOn()) {
                    this.debug("Lookup: '" + this.m_Key + "' -> '" + value + "'");
                }
                this.m_OutputToken = new Token((Object)value);
            } else {
                switch (this.m_MissingKey) {
                    case NO_OUTPUT: {
                        this.getSystemErr().println("Key '" + this.m_Key + "' not available from lookup table '" + this.m_StorageName + "'!");
                        break;
                    }
                    case CAUSE_ERROR: {
                        result = "Key '" + this.m_Key + "' not available from lookup table '" + this.m_StorageName + "'!";
                        break;
                    }
                    case OUTPUT_KEY: {
                        this.m_OutputToken = new Token((Object)this.m_Key);
                        break;
                    }
                    case OUTPUT_MISSING_VALUE: {
                        this.m_OutputToken = new Token((Object)this.m_MissingValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled missing key behavior: " + (Object)((Object)this.m_MissingKey));
                    }
                }
            }
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

