/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.transformer.LookUpInit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class LookUpTable
extends AbstractSource {
    private static final long serialVersionUID = -4888807180866059350L;
    protected StorageName m_StorageName;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Outputs the specified lookup table as spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
    }

    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public String getQuickInfo() {
        String result = "storage: ";
        String variable = this.getOptionManager().getVariableForProperty("storageName");
        result = variable != null ? result + variable : result + this.m_StorageName.getValue();
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the lookup table in the internal storage.";
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            HashMap lookup = (HashMap)this.getStorageHandler().getStorage().get(this.m_StorageName);
            SpreadSheet sheet = new SpreadSheet();
            sheet.setName(this.m_StorageName.getValue());
            sheet.getHeaderRow().addCell("k").setContent("Key");
            sheet.getHeaderRow().addCell("v").setContent("Value");
            ArrayList keys = new ArrayList(lookup.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                DataRow row = sheet.addRow();
                row.addCell("k").setContent(key);
                row.addCell("v").setContent((String)lookup.get(key));
            }
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

