/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Utils;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.DatabaseConnection;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;

public class SpreadSheetDbReader
extends AbstractSource {
    private static final long serialVersionUID = 494594301273926225L;
    protected SQLStatement m_Query;
    protected DataRowType m_DataRowType;
    protected int m_ChunkSize;
    protected Token m_OutputToken;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected ChunkReader m_Reader;

    public String globalInfo() {
        return "Returns a spreadsheet object generated from an SQL query.\nTo optimize memory consumption, you can return the result of the query in chunks of a specified size.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("query", "query", (Object)new SQLStatement("select * from blah"));
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)DataRowType.DENSE);
        this.m_OptionManager.add("chunk-size", "chunkSize", (Object)-1, (Number)-1, null);
    }

    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public String getQuickInfo() {
        String result = "query: ";
        String variable = this.getOptionManager().getVariableForProperty("query");
        result = variable != null ? result + variable : result + Utils.shorten((String)this.m_Query.stringValue(), (int)40);
        result = result + ",row type: ";
        variable = this.getOptionManager().getVariableForProperty("dataRowType");
        result = variable != null ? result + variable : result + this.m_DataRowType;
        variable = this.getOptionManager().getVariableForProperty("chunkSize");
        if (variable != null) {
            result = result + ", chunk: " + variable;
        } else if (this.m_ChunkSize > 0) {
            result = result + ", chunk: " + this.m_ChunkSize;
        }
        return result;
    }

    public void setQuery(SQLStatement value) {
        this.m_Query = value;
        this.reset();
    }

    public SQLStatement getQuery() {
        return this.m_Query;
    }

    public String queryTipText() {
        return "The SQL query to use for generating the spreadsheet.";
    }

    public void setDataRowType(DataRowType value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRowType getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public void setChunkSize(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ChunkSize = value;
        this.reset();
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The maximum number of rows per chunk; using -1 will read put all data into a single spreadsheet object.";
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((AbstractActor)this, DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton());
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = null;
        try {
            SQL sql = new SQL(this.m_DatabaseConnection);
            this.m_Reader = new ChunkReader(this);
            sheet = this.m_Reader.read(sql.getResultSet(this.m_Query.getValue()), this.m_ChunkSize);
        }
        catch (Exception e) {
            result = this.handleException("Failed to retrieve data from database", e);
        }
        if (this.m_Stopped) {
            result = null;
        }
        if (result == null) {
            this.m_OutputToken = new Token(sheet);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        if (this.m_OutputToken != null) {
            return true;
        }
        if (this.m_Reader == null) {
            return false;
        }
        return this.m_Reader.hasNext();
    }

    public Token output() {
        Token result = null;
        if (this.m_OutputToken != null) {
            result = this.m_OutputToken;
            this.m_OutputToken = null;
        } else if (this.m_Reader.hasNext()) {
            result = new Token((Object)this.m_Reader.next());
        }
        return result;
    }

    public void wrapUp() {
        this.m_DatabaseConnection = null;
        this.m_Reader = null;
        super.wrapUp();
    }

    public static class ChunkReader
    implements Serializable {
        private static final long serialVersionUID = -6514314165815537830L;
        protected SpreadSheetDbReader m_Owner;
        protected int m_ChunkSize;
        protected ResultSet m_ResultSet;
        protected SpreadSheet m_Header;
        protected int[] m_Type;

        public ChunkReader(SpreadSheetDbReader owner) {
            this.m_Owner = owner;
        }

        public SpreadSheet read(ResultSet rs, int chunkSize) {
            this.m_ResultSet = rs;
            this.m_ChunkSize = chunkSize;
            this.m_Type = new int[0];
            return this.next();
        }

        public boolean hasNext() {
            return this.m_ResultSet != null;
        }

        public SpreadSheet next() {
            SpreadSheet result = null;
            boolean finished = false;
            try {
                int i;
                HeaderRow row;
                if (this.m_Header == null) {
                    result = new SpreadSheet();
                    result.setDataRowClass(this.m_Owner.getDataRowType().getRowClass());
                    row = result.getHeaderRow();
                    ResultSetMetaData meta = this.m_ResultSet.getMetaData();
                    this.m_Type = new int[meta.getColumnCount()];
                    for (i = 1; i <= meta.getColumnCount(); ++i) {
                        row.addCell("" + i).setContentAsString(meta.getColumnName(i));
                        this.m_Type[i - 1] = meta.getColumnType(i);
                    }
                    this.m_Header = result.getHeader();
                    finished = !this.m_ResultSet.next();
                } else {
                    result = this.m_Header.getHeader();
                }
                while (!finished && !this.m_Owner.isStopped()) {
                    row = result.addRow();
                    for (i = 1; i <= result.getColumnCount(); ++i) {
                        switch (this.m_Type[i - 1]) {
                            case 92: {
                                row.addCell(i - 1).setContent((Date)this.m_ResultSet.getTime(i));
                                break;
                            }
                            case 91: {
                                row.addCell(i - 1).setContent((Date)this.m_ResultSet.getDate(i));
                                break;
                            }
                            case 93: {
                                row.addCell(i - 1).setContent((Date)this.m_ResultSet.getTimestamp(i));
                                break;
                            }
                            case 4: {
                                row.addCell(i - 1).setContent(Integer.valueOf(this.m_ResultSet.getInt(i)));
                                break;
                            }
                            case 6: {
                                row.addCell(i - 1).setContent(Float.valueOf(this.m_ResultSet.getFloat(i)));
                                break;
                            }
                            case 8: {
                                row.addCell(i - 1).setContent(Double.valueOf(this.m_ResultSet.getDouble(i)));
                                break;
                            }
                            default: {
                                row.addCell(i - 1).setContent(this.m_ResultSet.getString(i));
                            }
                        }
                        if (!this.m_ResultSet.wasNull()) continue;
                        row.getCell(i - 1).setMissing();
                    }
                    boolean bl = finished = !this.m_ResultSet.next();
                    if (this.m_ChunkSize <= 0 || result.getRowCount() != this.m_ChunkSize) continue;
                    break;
                }
            }
            catch (Exception e) {
                result = null;
                this.m_Owner.getSystemErr().printStackTrace("Failed to read data!", (Throwable)e);
            }
            if (finished || this.m_Owner.isStopped()) {
                SQL.closeAll((ResultSet)this.m_ResultSet);
                this.m_ResultSet = null;
            }
            if (this.m_Owner.isStopped()) {
                result = null;
            }
            return result;
        }
    }
}

