/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.StorageName;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import java.util.HashMap;

public class LookUpInit
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 4182914190162129217L;
    protected StorageName m_StorageName;
    protected Index m_KeyColumn;
    protected Index m_ValueColumn;

    public String globalInfo() {
        return "Creates a lookup table from a spreadsheet, using one column as key and another one as value. The lookup table itself gets stored in the internal storage under the specified name.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
        this.m_OptionManager.add("key-column", "keyColumn", (Object)new Index("1"));
        this.m_OptionManager.add("value-column", "valueColumn", (Object)new Index("2"));
    }

    public String getQuickInfo() {
        String result = "storage: ";
        String variable = this.getOptionManager().getVariableForProperty("storageName");
        result = variable != null ? result + variable : result + this.m_StorageName.getValue();
        result = result + ", key: ";
        variable = this.getOptionManager().getVariableForProperty("keyColumn");
        result = variable != null ? result + variable : result + this.m_KeyColumn.getIndex();
        result = result + ", value: ";
        variable = this.getOptionManager().getVariableForProperty("valueColumn");
        result = variable != null ? result + variable : result + this.m_ValueColumn.getIndex();
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    public void setKeyColumn(Index value) {
        this.m_KeyColumn = value;
        this.reset();
    }

    public Index getKeyColumn() {
        return this.m_KeyColumn;
    }

    public String keyColumnTipText() {
        return "The index of the column in the spreadsheet to use as key; " + this.m_KeyColumn.getExample();
    }

    public void setValueColumn(Index value) {
        this.m_ValueColumn = value;
        this.reset();
    }

    public Index getValueColumn() {
        return this.m_ValueColumn;
    }

    public String valueColumnTipText() {
        return "The index of the column in the spreadsheet to use as value; " + this.m_ValueColumn.getExample();
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        int keyCol = -1;
        int valCol = -1;
        if (sheet.getColumnCount() < 2) {
            result = "Spreadsheet must have at least 2 columns, available: " + sheet.getColumnCount();
        }
        if (result == null) {
            this.m_KeyColumn.setMax(sheet.getColumnCount());
            keyCol = this.m_KeyColumn.getIntIndex();
            if (keyCol == -1) {
                result = "Failed to locate key column: " + this.m_KeyColumn.getIndex();
            }
        }
        if (result == null) {
            this.m_ValueColumn.setMax(sheet.getColumnCount());
            valCol = this.m_ValueColumn.getIntIndex();
            if (valCol == -1) {
                result = "Failed to locate value column: " + this.m_ValueColumn.getIndex();
            }
        }
        if (result == null) {
            HashMap<String, String> lookup = new HashMap<String, String>();
            for (DataRow row : sheet.rows()) {
                if (!row.hasCell(keyCol) || !row.hasCell(valCol)) continue;
                String key = row.getCell(keyCol).getContent();
                String val = row.getCell(valCol).getContent();
                if (key == null || val == null) continue;
                lookup.put(key, val);
                if (!this.isDebugOn()) continue;
                this.debug("Adding: '" + key + "' -> '" + val + "'");
            }
            this.getStorageHandler().getStorage().put(this.m_StorageName, lookup);
        }
        if (result == null) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }
}

