/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateTime;
import adams.core.Time;
import adams.data.conversion.Conversion;
import adams.data.conversion.ObjectToObject;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.AbstractCellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.CellRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Date;
import java.util.Iterator;

public class SpreadSheetConvertCells
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -4633161214275622241L;
    protected AbstractCellFinder m_Finder;
    protected Conversion m_Conversion;

    public String globalInfo() {
        return "Finds cells in a spreadsheet and converts them with a conversion scheme.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new CellRange());
        this.m_OptionManager.add("conversion", "conversion", (Object)new ObjectToObject());
    }

    public String getQuickInfo() {
        String result = "finder: ";
        String variable = this.getOptionManager().getVariableForProperty("finder");
        result = variable != null ? result + variable : result + ((Object)((Object)this.m_Finder)).getClass().getSimpleName();
        result = result + ", conversion: ";
        variable = this.getOptionManager().getVariableForProperty("conversion");
        result = variable != null ? result + variable : result + this.m_Conversion.getClass().getSimpleName();
        return result;
    }

    public void setFinder(AbstractCellFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public AbstractCellFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The cell finder to use.";
    }

    public void setConversion(Conversion value) {
        this.m_Conversion = value;
        this.reset();
    }

    public Conversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion to apply to the located cells.";
    }

    protected String convertCell(CellLocation location, SpreadSheet sheet) {
        if (!sheet.hasCell(location.getRow(), location.getColumn())) {
            return null;
        }
        String result = null;
        Cell cell = sheet.getCell(location.getRow(), location.getColumn());
        Object input = null;
        Object output = null;
        Class classIn = this.m_Conversion.accepts();
        Class classOut = this.m_Conversion.generates();
        if (classIn == Double.class) {
            input = cell.toDouble();
        } else if (classIn == Integer.class) {
            input = cell.toLong().intValue();
        } else if (classIn == Long.class) {
            input = cell.toLong();
        } else if (classIn == Date.class) {
            input = cell.toDate();
        } else if (classIn == DateTime.class) {
            input = cell.toDateTime();
        } else if (classIn == Time.class) {
            input = cell.toTime();
        } else if (classIn == String.class) {
            input = cell.getContent();
        } else {
            result = "Don't know how to get cell value for conversion input type: " + classIn.getName();
        }
        if (result == null) {
            this.m_Conversion.setInput(input);
            result = this.m_Conversion.convert();
        }
        if (result == null) {
            output = this.m_Conversion.getOutput();
            this.m_Conversion.cleanUp();
            if (classOut == Double.class) {
                cell.setContent((Double)output);
            } else if (classOut == Integer.class) {
                cell.setContent((Integer)output);
            } else if (classOut == Long.class) {
                cell.setContent((Long)output);
            } else if (classOut == Date.class) {
                cell.setContent((Date)output);
            } else if (classOut == DateTime.class) {
                cell.setContent((DateTime)output);
            } else if (classOut == Time.class) {
                cell.setContent((Time)output);
            } else if (classOut == String.class) {
                cell.setContent((String)output);
            } else {
                result = "Don't know how to set cell value for conversion output type: " + classOut.getName();
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        Iterator<CellLocation> cells = this.m_Finder.findCells(sheetNew);
        while (cells.hasNext() && (result = this.convertCell(cells.next(), sheetNew)) == null) {
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)sheetNew);
        }
        return result;
    }
}

