/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.Range;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetCopyColumns
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 9030574317512531337L;
    protected Range m_Columns;
    protected Index m_Position;
    protected boolean m_After;
    protected String m_Prefix;

    public String globalInfo() {
        return "Copies a range of columns to a specific position in the spreadsheets coming through.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new Index();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new Range("first-last"));
        this.m_OptionManager.add("position", "position", (Object)new Index("first"));
        this.m_OptionManager.add("after", "after", (Object)false);
        this.m_OptionManager.add("prefix", "prefix", (Object)"Copy-");
    }

    public String getQuickInfo() {
        String result = "columns: ";
        String variable = this.getOptionManager().getVariableForProperty("columns");
        result = variable != null ? result + variable : result + this.m_Columns.getRange();
        result = this.m_After ? result + ", after: " : result + ", at: ";
        variable = this.getOptionManager().getVariableForProperty("position");
        result = variable != null ? result + variable : result + this.m_Position.getIndex();
        variable = this.getOptionManager().getVariableForProperty("prefix");
        if (variable != null) {
            result = result + ", prefix: " + variable;
        } else if (this.m_Prefix.length() > 0) {
            result = result + ", prefix: " + this.m_Prefix;
        }
        return result;
    }

    public void setColumns(Range value) {
        this.m_Columns = value;
        this.reset();
    }

    public Range getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to copy; " + this.m_Columns.getExample();
    }

    public void setPosition(Index value) {
        this.m_Position = value;
        this.reset();
    }

    public Index getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the column; " + this.m_Position.getExample();
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the column is inserted after the position instead of at the position.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the column headers, can be empty.";
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = sheetOld.getHeader();
        this.m_Columns.setMax(sheetOld.getColumnCount());
        int[] fromPos = this.m_Columns.getIntIndices();
        int[] toPos = new int[fromPos.length];
        this.m_Position.setMax(sheetOld.getColumnCount());
        int pos = this.m_Position.getIntIndex();
        if (this.m_After) {
            ++pos;
        }
        for (i = 0; i < toPos.length; ++i) {
            toPos[i] = pos + i;
        }
        for (i = 0; i < fromPos.length; ++i) {
            String header = sheetOld.getHeaderRow().getContent(fromPos[i]);
            sheetNew.insertColumn(toPos[i], this.m_Prefix + header);
        }
        for (DataRow rowOld : sheetOld.rows()) {
            DataRow rowNew = sheetNew.addRow();
            for (String key : rowOld.cellKeys()) {
                rowNew.addCell(key).assign(rowOld.getCell(key));
            }
            for (i = 0; i < fromPos.length; ++i) {
                Cell cell = rowOld.getCell(fromPos[i]);
                rowNew.getCell(toPos[i]).assign(cell);
            }
        }
        this.m_OutputToken = new Token((Object)sheetNew);
        return result;
    }
}

