/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;

public class SpreadSheetGetColumnIndex
extends AbstractTransformer {
    private static final long serialVersionUID = 1312054113479943728L;
    public static final String BACKUP_QUEUE = "queue";
    protected BaseRegExp m_ColumnName;
    protected ArrayList<Integer> m_Queue;

    public String globalInfo() {
        return "Obtain the 1-based indices of columns that match a user-specified regular expression.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column-name", "columnName", (Object)new BaseRegExp(".*"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_QUEUE);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Queue != null) {
            result.put(BACKUP_QUEUE, this.m_Queue);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_QUEUE)) {
            this.m_Queue = (ArrayList)state.get(BACKUP_QUEUE);
            state.remove(BACKUP_QUEUE);
        }
        super.restoreState(state);
    }

    public void setColumnName(BaseRegExp value) {
        this.m_ColumnName = value;
        this.reset();
    }

    public BaseRegExp getColumnName() {
        return this.m_ColumnName;
    }

    public String columnNameTipText() {
        return "The regular expression to match the column name.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("columnName");
        String result = variable != null ? variable : this.m_ColumnName.getValue();
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{Integer.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        HeaderRow row = sheet.getHeaderRow();
        this.m_Queue.clear();
        for (int i = 0; i < sheet.getColumnCount(); ++i) {
            if (!row.hasCell(i) || !this.m_ColumnName.isMatch(row.getCell(i).getContent())) continue;
            this.m_Queue.add(i + 1);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue != null && !this.m_Queue.isEmpty();
    }

    public Token output() {
        Token result = new Token((Object)this.m_Queue.get(0));
        this.m_Queue.remove(0);
        return result;
    }

    public void wrapUp() {
        if (this.m_Queue != null) {
            this.m_Queue.clear();
        }
        super.wrapUp();
    }

    public void cleanUp() {
        this.m_Queue = null;
        super.cleanUp();
    }
}

