/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class SpreadSheetInfo
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;
    protected Index m_ColumnIndex;
    protected List m_Queue;

    public String globalInfo() {
        return "Outputs statistics of a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.NUM_ROWS);
        this.m_OptionManager.add("column-index", "columnIndex", (Object)new Index("last"));
    }

    protected void initialize() {
        super.initialize();
        this.m_ColumnIndex = new Index();
        this.m_Queue = new ArrayList();
    }

    public String getQuickInfo() {
        String result = null;
        String variable = this.getOptionManager().getVariableForProperty("type");
        result = variable != null ? variable : "" + (Object)((Object)this.m_Type);
        HashSet<InfoType> types = new HashSet<InfoType>(Arrays.asList(InfoType.NUM_COLUMNS, InfoType.NUM_ROWS));
        if (!types.contains((Object)this.m_Type)) {
            result = result + ", index: ";
            variable = this.getOptionManager().getVariableForProperty("columnIndex");
            result = variable != null ? result + variable : result + this.m_ColumnIndex.getIndex();
        }
        return result;
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public void setColumnIndex(Index value) {
        this.m_ColumnIndex = value;
        this.reset();
    }

    public Index getColumnIndex() {
        return this.m_ColumnIndex;
    }

    public String columnIndexTipText() {
        return "The column index to use for generating column-specific information. " + this.m_ColumnIndex.getExample();
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case COLUMN_NAME: 
            case COLUMN_TYPE: 
            case CELL_TYPES: {
                return new Class[]{String.class};
            }
            case NUM_COLUMNS: 
            case NUM_ROWS: {
                return new Class[]{Integer.class};
            }
        }
        throw new IllegalStateException("Unhandled info type: " + (Object)((Object)this.m_Type));
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue = new ArrayList();
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_ColumnIndex.setMax(sheet.getColumnCount());
        switch (this.m_Type) {
            case COLUMN_NAME: {
                int index = this.m_ColumnIndex.getIntIndex();
                if (index == -1) break;
                this.m_Queue.add(sheet.getHeaderRow().getCell(index).getContent());
                break;
            }
            case NUM_COLUMNS: {
                this.m_Queue.add(sheet.getColumnCount());
                break;
            }
            case NUM_ROWS: {
                this.m_Queue.add(sheet.getRowCount());
                break;
            }
            case COLUMN_TYPE: {
                int index = this.m_ColumnIndex.getIntIndex();
                if (index == -1) break;
                Cell.ContentType type = sheet.getContentType(index);
                if (type == null) {
                    type = Cell.ContentType.STRING;
                }
                this.m_Queue.add(type.toString());
                break;
            }
            case CELL_TYPES: {
                int index = this.m_ColumnIndex.getIntIndex();
                if (index == -1) break;
                Collection types = sheet.getContentTypes(index);
                for (Cell.ContentType ct : types) {
                    this.m_Queue.add(ct.toString());
                }
                break;
            }
            default: {
                result = "Unhandled info type: " + (Object)((Object)this.m_Type);
            }
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue != null && this.m_Queue.size() > 0;
    }

    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_InputToken = null;
        this.m_Queue.remove(0);
        return result;
    }

    public void wrapUp() {
        this.m_Queue = null;
        super.wrapUp();
    }

    public static enum InfoType {
        NUM_COLUMNS,
        NUM_ROWS,
        COLUMN_NAME,
        COLUMN_TYPE,
        CELL_TYPES;

    }
}

