/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetRemoveColumn
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 6726489537611573393L;
    protected Index m_Position;

    public String globalInfo() {
        return "Removes the column at the specific position from spreadsheets coming through.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new Index();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", (Object)new Index("last"));
    }

    public String getQuickInfo() {
        String result = "at: ";
        String variable = this.getOptionManager().getVariableForProperty("position");
        result = variable != null ? result + variable : result + this.m_Position.getIndex();
        return result;
    }

    public void setPosition(Index value) {
        this.m_Position = value;
        this.reset();
    }

    public Index getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position of the column to remove; " + this.m_Position.getExample();
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        sheet = sheet.getClone();
        this.m_Position.setMax(sheet.getColumnCount());
        int index = this.m_Position.getIntIndex();
        if (index > -1) {
            sheet.removeColumn(index);
            this.m_OutputToken = new Token((Object)sheet);
        } else {
            result = "Column " + this.m_Position.getIndex() + " does not exist!";
        }
        return result;
    }
}

