/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;

public class SpreadSheetRemoveRow
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -1424259429280086410L;
    protected Index m_Position;

    public String globalInfo() {
        return "Removes a row at the specific position from spreadsheets coming through.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new Index();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", (Object)new Index("last"));
    }

    public String getQuickInfo() {
        String result = "at: ";
        String variable = this.getOptionManager().getVariableForProperty("position");
        result = variable != null ? result + variable : result + this.m_Position.getIndex();
        if (this.m_NoCopy) {
            result = result + ", no copy";
        }
        return result;
    }

    public void setPosition(Index value) {
        this.m_Position = value;
        this.reset();
    }

    public Index getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position of the row to remove; " + this.m_Position.getExample();
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        if (!this.m_NoCopy) {
            sheet = sheet.getClone();
        }
        this.m_Position.setMax(sheet.getRowCount());
        int index = this.m_Position.getIntIndex();
        if (index > -1) {
            sheet.removeRow(index);
            this.m_OutputToken = new Token((Object)sheet);
        } else {
            result = "Row " + this.m_Position.getIndex() + " does not exist!";
        }
        return result;
    }
}

