/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.Utils;
import adams.core.base.BaseBoolean;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;

public class SpreadSheetSort
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = 8621434041912535939L;
    protected Index[] m_SortColumn;
    protected BaseBoolean[] m_SortOrder;

    public String globalInfo() {
        return "Sorts the rows of the spreadsheet according to the selected column indices and sort order (ascending/descending).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sort-column", "sortColumn", (Object)new Index[]{new Index("first")});
        this.m_OptionManager.add("sort-order", "sortOrder", (Object)new BaseBoolean[]{new BaseBoolean(Boolean.valueOf(true))});
    }

    protected void initialize() {
        super.initialize();
        this.m_SortColumn = new Index[0];
        this.m_SortOrder = new BaseBoolean[0];
    }

    public String getQuickInfo() {
        String result = "";
        for (int i = 0; i < this.m_SortColumn.length; ++i) {
            if (i > 0) {
                result = result + " and ";
            }
            result = result + this.m_SortColumn[i].getIndex();
            if (this.m_SortOrder[i].booleanValue()) continue;
            result = result + " (desc)";
        }
        if (this.m_NoCopy) {
            result = result + ", no copy";
        }
        return result;
    }

    public void setSortColumn(Index[] value) {
        this.m_SortColumn = value;
        if (this.m_SortColumn.length != this.m_SortOrder.length) {
            Utils.adjustArray((Object)this.m_SortOrder, (int)this.m_SortColumn.length, (Object)new BaseBoolean(Boolean.valueOf(true)));
        }
        this.reset();
    }

    public Index[] getSortColumn() {
        return this.m_SortColumn;
    }

    public String sortColumnTipText() {
        return "The columns to use for sorting; " + new Index().getExample();
    }

    public void setSortOrder(BaseBoolean[] value) {
        this.m_SortOrder = value;
        if (this.m_SortColumn.length != this.m_SortOrder.length) {
            Utils.adjustArray((Object)this.m_SortColumn, (int)this.m_SortOrder.length, (Object)new Index("first"));
        }
        this.reset();
    }

    public BaseBoolean[] getSortOrder() {
        return this.m_SortOrder;
    }

    public String sortOrderTipText() {
        return "The order of sorting for the columns (true = ascending, false = descending).";
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        if (!this.m_NoCopy) {
            sheet = sheet.getClone();
        }
        int[] indices = new int[this.m_SortColumn.length];
        for (i = 0; i < this.m_SortColumn.length; ++i) {
            this.m_SortColumn[i].setMax(sheet.getColumnCount());
            indices[i] = this.m_SortColumn[i].getIntIndex();
        }
        boolean[] order = new boolean[this.m_SortOrder.length];
        for (i = 0; i < this.m_SortOrder.length; ++i) {
            order[i] = this.m_SortOrder[i].booleanValue();
        }
        RowComparator comp = new RowComparator(indices, order);
        sheet.sort(comp);
        this.m_OutputToken = new Token((Object)sheet);
        return result;
    }
}

