/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.Utils;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;

public class SpreadSheetStorageRowIterator
extends AbstractTransformer {
    private static final long serialVersionUID = 1117931423508873847L;
    public static final String BACKUP_QUEUE = "queue";
    public static final String BACKUP_SHEET = "sheet";
    public static final String BACKUP_COLUMNS = "columns";
    protected Range m_Columns;
    protected Range m_Rows;
    protected String m_StoragePrefix;
    protected String m_MissingValue;
    protected ArrayList<Integer> m_Queue;
    protected SpreadSheet m_Sheet;
    protected int[] m_ColumnIndices;

    public String globalInfo() {
        return "Iterates through a defined range of rows. In each iteration the cell values of the defined column range are mapped to storage values.\nBy default the (cleaned up) header names of the columns are used as storage names. To avoid name clashes, a prefix can be chosen for the storage names.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rows", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add(BACKUP_COLUMNS, BACKUP_COLUMNS, (Object)new Range("first-last"));
        this.m_OptionManager.add("storage-prefix", "storagePrefix", (Object)"");
        this.m_OptionManager.add("missing-value", "missingValue", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
        this.m_Sheet = null;
        this.m_ColumnIndices = null;
    }

    protected void reset() {
        super.reset();
        this.m_Queue.clear();
        this.m_Sheet = null;
        this.m_ColumnIndices = null;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_QUEUE);
        this.pruneBackup(BACKUP_SHEET);
        this.pruneBackup(BACKUP_COLUMNS);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Queue != null) {
            result.put(BACKUP_QUEUE, this.m_Queue);
        }
        if (this.m_Sheet != null) {
            result.put(BACKUP_SHEET, this.m_Sheet);
        }
        if (this.m_ColumnIndices != null) {
            result.put(BACKUP_COLUMNS, this.m_ColumnIndices);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_QUEUE)) {
            this.m_Queue = (ArrayList)state.get(BACKUP_QUEUE);
            state.remove(BACKUP_QUEUE);
        }
        if (state.containsKey(BACKUP_SHEET)) {
            this.m_Sheet = (SpreadSheet)state.get(BACKUP_SHEET);
            state.remove(BACKUP_SHEET);
        }
        if (state.containsKey(BACKUP_COLUMNS)) {
            this.m_ColumnIndices = (int[])state.get(BACKUP_COLUMNS);
            state.remove(BACKUP_COLUMNS);
        }
        super.restoreState(state);
    }

    public void setColumns(Range value) {
        this.m_Columns = value;
        this.reset();
    }

    public Range getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns to retrieve the values from; " + this.m_Columns.getExample();
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The rows to retrieve the values from; " + this.m_Columns.getExample();
    }

    public void setStoragePrefix(String value) {
        this.m_StoragePrefix = value;
        this.reset();
    }

    public String getStoragePrefix() {
        return this.m_StoragePrefix;
    }

    public String storagePrefixTipText() {
        return "The prefix to prepend the header names with to make up the storage name.";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The value to use as storage value in case of missing cells.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("rows");
        String result = "rows: ";
        result = variable != null ? result + variable : result + this.m_Rows.getRange();
        variable = this.getOptionManager().getVariableForProperty(BACKUP_COLUMNS);
        result = result + ", cols: ";
        result = variable != null ? result + variable : result + this.m_Columns.getRange();
        variable = this.getOptionManager().getVariableForProperty("storagePrefix");
        if (variable != null) {
            result = result + ", prefix: " + variable;
        } else if (this.m_StoragePrefix.length() > 0) {
            result = result + ", prefix: " + this.m_StoragePrefix;
        }
        variable = this.getOptionManager().getVariableForProperty("missingValue");
        if (variable != null) {
            result = result + ", missing: " + variable;
        } else if (this.m_MissingValue.length() > 0) {
            result = result + ", missing: " + this.m_MissingValue;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        this.m_Sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Columns.setMax(this.m_Sheet.getColumnCount());
        if (this.m_Columns.getIntIndices().length == 0) {
            result = "No columns available with range '" + this.m_Columns.getRange() + "'?";
        }
        if (result == null) {
            this.m_Rows.setMax(this.m_Sheet.getRowCount());
            if (this.m_Rows.getIntIndices().length == 0) {
                result = "No rows available with range '" + this.m_Rows.getRange() + "'?";
            }
        }
        if (result == null) {
            this.m_ColumnIndices = this.m_Columns.getIntIndices();
            this.m_Queue.addAll(Utils.toList((int[])this.m_Rows.getIntIndices()));
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Queue != null && !this.m_Queue.isEmpty();
    }

    public Token output() {
        Token result = new Token((Object)this.m_Sheet);
        int rowIndex = this.m_Queue.get(0);
        this.m_Queue.remove(0);
        HeaderRow header = this.m_Sheet.getHeaderRow();
        DataRow row = this.m_Sheet.getRow(rowIndex);
        for (int i = 0; i < this.m_ColumnIndices.length; ++i) {
            int col = this.m_ColumnIndices[i];
            StorageName name = new StorageName(Storage.toValidName((String)(this.m_StoragePrefix + header.getCell(col).getContent())));
            if (!row.hasCell(col)) {
                this.getStorageHandler().getStorage().put(name, (Object)this.m_MissingValue);
                continue;
            }
            this.getStorageHandler().getStorage().put(name, (Object)row.getCell(col).getContent());
        }
        return result;
    }

    public void wrapUp() {
        if (this.m_Queue != null) {
            this.m_Queue.clear();
        }
        this.m_Sheet = null;
        super.wrapUp();
    }

    public void cleanUp() {
        this.m_Queue = null;
        super.cleanUp();
    }
}

