/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetSubset
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = -253714973019682939L;
    protected Range m_Rows;
    protected Range m_Columns;

    public String globalInfo() {
        return "Extracts a subset of rows/columns from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("col", "columns", (Object)new Range("first-last"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Rows = new Range();
        this.m_Columns = new Range();
    }

    public String getQuickInfo() {
        String variableRow = this.getOptionManager().getVariableForProperty("rows");
        String variableCol = this.getOptionManager().getVariableForProperty("columns");
        String result = "rows: ";
        result = variableRow != null ? result + variableRow : result + this.m_Rows.getRange();
        result = result + "/";
        result = result + "cols: ";
        result = variableCol != null ? result + variableCol : result + this.m_Columns.getRange();
        return result;
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The rows of the subset to retrieve; " + this.m_Rows.getExample();
    }

    public void setColumns(Range value) {
        this.m_Columns = value;
        this.reset();
    }

    public Range getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns of the subset to retrieve; " + this.m_Columns.getExample();
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Rows.setMax(sheet.getRowCount());
        this.m_Columns.setMax(sheet.getColumnCount());
        int[] rows = this.m_Rows.getIntIndices();
        int[] cols = this.m_Columns.getIntIndices();
        if (cols.length == 0) {
            result = "No columns selected!";
        } else {
            int i;
            SpreadSheet subset = new SpreadSheet();
            for (i = 0; i < cols.length; ++i) {
                subset.getHeaderRow().addCell("" + (i + 1)).setContent(sheet.getHeaderRow().getCell(cols[i]).getContent());
            }
            for (int n = 0; n < rows.length; ++n) {
                DataRow row = sheet.getRow(rows[n]);
                DataRow subrow = subset.addRow("" + subset.getRowCount());
                for (i = 0; i < cols.length; ++i) {
                    subrow.addCell("" + (i + 1)).setContent(row.getCell(cols[i]).getContent());
                }
            }
            this.m_OutputToken = new Token((Object)subset);
        }
        return result;
    }
}

