/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import java.util.List;

public abstract class AbstractPlotGenerator
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = -7535085726098063330L;
    public static final String MISSING_CELL_VALUE = "MISSING";
    protected double m_DefaultCellValue;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("default-cell-value", "defaultCellValue", (Object)-1.0);
    }

    public void setDefaultCellValue(double value) {
        this.m_DefaultCellValue = value;
        this.reset();
    }

    public double getDefaultCellValue() {
        return this.m_DefaultCellValue;
    }

    public String defaultCellValueTipText() {
        return "The default value for missing or non-numeric cells.";
    }

    public String getQuickInfo() {
        return null;
    }

    protected void check(SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalStateException("No spreadsheet provided!");
        }
    }

    protected String getCellString(Row row, int index) {
        String result = MISSING_CELL_VALUE;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.getContent();
        }
        return result;
    }

    protected double getCellValue(Row row, int index) {
        double result = this.m_DefaultCellValue;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing() && cell.isNumeric()) {
            result = Double.parseDouble(cell.getContent());
        }
        return result;
    }

    protected abstract List<SequencePlotterContainer> doGenerate(SpreadSheet var1);

    public List<SequencePlotterContainer> generate(SpreadSheet sheet) {
        this.check(sheet);
        return this.doGenerate(sheet);
    }
}

