/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.Index;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import java.util.ArrayList;
import java.util.List;

public class NamedPlotGenerator
extends AbstractPlotGenerator {
    private static final long serialVersionUID = 114825117464139953L;
    protected Index m_XColumn;
    protected Index m_YColumn;
    protected Index m_NameColumn;

    public String globalInfo() {
        return "Plots the numeric data of two columns, X and Y with the plot name from a separate column.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x-column", "XColumn", (Object)"");
        this.m_OptionManager.add("y-column", "YColumn", (Object)"");
        this.m_OptionManager.add("name-column", "nameColumn", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_XColumn = new Index();
        this.m_YColumn = new Index();
        this.m_NameColumn = new Index();
    }

    @Override
    public String getQuickInfo() {
        String result = "x: ";
        String variable = this.getOptionManager().getVariableForProperty("XColumn");
        result = variable != null ? result + variable : result + this.m_XColumn.getIndex();
        result = result + ", y: ";
        variable = this.getOptionManager().getVariableForProperty("YColumn");
        result = variable != null ? result + variable : result + this.m_YColumn.getIndex();
        result = result + ", name: ";
        variable = this.getOptionManager().getVariableForProperty("nameColumn");
        result = variable != null ? result + variable : result + this.m_NameColumn.getIndex();
        return result;
    }

    public void setXColumn(String value) {
        this.m_XColumn.setIndex(value);
        this.reset();
    }

    public String getXColumn() {
        return this.m_XColumn.getIndex();
    }

    public String XColumnTipText() {
        return "The index of the column which values to use as X values in the plot; " + this.m_XColumn.getExample();
    }

    public void setYColumn(String value) {
        this.m_YColumn.setIndex(value);
        this.reset();
    }

    public String getYColumn() {
        return this.m_YColumn.getIndex();
    }

    public String YColumnTipText() {
        return "The index of the column which values to use as Y values in the plot; " + this.m_YColumn.getExample();
    }

    public void setNameColumn(String value) {
        this.m_NameColumn.setIndex(value);
        this.reset();
    }

    public String getNameColumn() {
        return this.m_NameColumn.getIndex();
    }

    public String nameColumnTipText() {
        return "The index of the column which values to use as for naming the plots; " + this.m_NameColumn.getExample();
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_XColumn.setMax(sheet.getColumnCount());
        if (this.m_XColumn.getIntIndex() == -1) {
            throw new IllegalStateException("No X column defined/available?");
        }
        if (!sheet.isNumeric(this.m_XColumn.getIntIndex())) {
            throw new IllegalStateException("X column is not numeric!");
        }
        this.m_YColumn.setMax(sheet.getColumnCount());
        if (this.m_YColumn.getIntIndex() == -1) {
            throw new IllegalStateException("No Y column defined/available?");
        }
        if (!sheet.isNumeric(this.m_YColumn.getIntIndex())) {
            throw new IllegalStateException("Y column is not numeric!");
        }
        this.m_NameColumn.setMax(sheet.getColumnCount());
        if (this.m_NameColumn.getIntIndex() == -1) {
            throw new IllegalStateException("No name column defined/available?");
        }
    }

    @Override
    protected List<SequencePlotterContainer> doGenerate(SpreadSheet sheet) {
        ArrayList<SequencePlotterContainer> result = new ArrayList<SequencePlotterContainer>();
        int xCol = this.m_XColumn.getIntIndex();
        int yCol = this.m_YColumn.getIntIndex();
        int nameCol = this.m_NameColumn.getIntIndex();
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            SequencePlotterContainer cont = new SequencePlotterContainer(this.getCellString((Row)row, nameCol), Double.valueOf(this.getCellValue((Row)row, xCol)), Double.valueOf(this.getCellValue((Row)row, yCol)));
            result.add(cont);
        }
        return result;
    }
}

