/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.Range;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import java.util.ArrayList;
import java.util.List;

public class SimplePlotGenerator
extends AbstractPlotGenerator {
    private static final long serialVersionUID = -1679247321811941656L;
    protected Range m_PlotColumns;

    public String globalInfo() {
        return "Plots the numeric data from one or more columns. The plot name is the column name and the X value is the row index.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "plotColumns", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_PlotColumns = new Range();
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("plotColumns");
        if (variable != null) {
            return variable;
        }
        if (this.m_PlotColumns.getRange().length() > 0) {
            return this.m_PlotColumns.getRange();
        }
        return null;
    }

    public void setPlotColumns(String value) {
        this.m_PlotColumns.setRange(value);
        this.reset();
    }

    public String getPlotColumns() {
        return this.m_PlotColumns.getRange();
    }

    public String plotColumnsTipText() {
        return "The range of columns to include in the plot; " + this.m_PlotColumns.getExample();
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_PlotColumns.setMax(sheet.getColumnCount());
        if (this.m_PlotColumns.getIntIndices().length == 0) {
            throw new IllegalStateException("No plot columns defined/available?");
        }
    }

    @Override
    protected List<SequencePlotterContainer> doGenerate(SpreadSheet sheet) {
        int i;
        ArrayList<SequencePlotterContainer> result = new ArrayList<SequencePlotterContainer>();
        int[] plotCols = this.m_PlotColumns.getIntIndices();
        String[] plotNames = new String[plotCols.length];
        for (i = 0; i < plotNames.length; ++i) {
            plotNames[i] = sheet.getHeaderRow().getCell(plotCols[i]).getContent();
        }
        for (i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            for (int n = 0; n < plotCols.length; ++n) {
                SequencePlotterContainer cont = new SequencePlotterContainer(plotNames[n], new Double(i), Double.valueOf(this.getCellValue((Row)row, plotCols[n])));
                result.add(cont);
            }
        }
        return result;
    }
}

