/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.Index;
import adams.core.Range;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class XYPlotGenerator
extends AbstractPlotGenerator {
    private static final long serialVersionUID = 2881757430571628883L;
    protected Range m_PlotColumns;
    protected Index m_XColumn;
    protected Range m_PrefixColumns;

    public String globalInfo() {
        return "Uses one column for the X value and one or more other columns as Y to plot against.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "plotColumns", (Object)"");
        this.m_OptionManager.add("x-column", "XColumn", (Object)"");
        this.m_OptionManager.add("prefix-columns", "prefixColumns", (Object)new Range());
    }

    protected void initialize() {
        super.initialize();
        this.m_PlotColumns = new Range();
        this.m_XColumn = new Index();
    }

    @Override
    public String getQuickInfo() {
        String result = "x: ";
        String variable = this.getOptionManager().getVariableForProperty("XColumn");
        result = variable != null ? result + variable : result + this.m_XColumn.getIndex();
        result = result + ", y cols: ";
        variable = this.getOptionManager().getVariableForProperty("plotColumns");
        result = variable != null ? result + variable : result + this.m_PlotColumns.getRange();
        result = result + ", prefix: ";
        variable = this.getOptionManager().getVariableForProperty("prefixColumns");
        result = variable != null ? result + variable : result + this.m_PrefixColumns.getRange();
        return result;
    }

    public void setPlotColumns(String value) {
        this.m_PlotColumns.setRange(value);
        this.reset();
    }

    public String getPlotColumns() {
        return this.m_PlotColumns.getRange();
    }

    public String plotColumnsTipText() {
        return "The range of columns to include in the plot; " + this.m_PlotColumns.getExample();
    }

    public void setXColumn(String value) {
        this.m_XColumn.setIndex(value);
        this.reset();
    }

    public String getXColumn() {
        return this.m_XColumn.getIndex();
    }

    public String XColumnTipText() {
        return "The (optional) index of the column which values to use as X values in the plot; " + this.m_XColumn.getExample();
    }

    public void setPrefixColumns(Range value) {
        this.m_PrefixColumns = value;
        this.reset();
    }

    public Range getPrefixColumns() {
        return this.m_PrefixColumns;
    }

    public String prefixColumnsTipText() {
        return "The range of columns to prefix the plot name with; " + this.m_PlotColumns.getExample();
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_PlotColumns.setMax(sheet.getColumnCount());
        if (this.m_PlotColumns.getIntIndices().length == 0) {
            throw new IllegalStateException("No plot columns defined/available?");
        }
        this.m_XColumn.setMax(sheet.getColumnCount());
        if (this.m_XColumn.getIntIndex() == -1) {
            throw new IllegalStateException("No X column defined/available?");
        }
        this.m_PrefixColumns.setMax(sheet.getColumnCount());
    }

    @Override
    protected List<SequencePlotterContainer> doGenerate(SpreadSheet sheet) {
        int i;
        ArrayList<SequencePlotterContainer> result = new ArrayList<SequencePlotterContainer>();
        int xIndex = this.m_XColumn.getIntIndex();
        Hashtable<String, Integer> xIndexString = null;
        if (xIndex != -1 && !sheet.isNumeric(xIndex)) {
            xIndexString = new Hashtable<String, Integer>();
        }
        int[] plotCols = this.m_PlotColumns.getIntIndices();
        String[] plotNames = new String[plotCols.length];
        int[] prefixCols = this.m_PrefixColumns.getIntIndices();
        for (i = 0; i < plotNames.length; ++i) {
            plotNames[i] = sheet.getHeaderRow().getCell(plotCols[i]).getContent();
        }
        for (i = 0; i < sheet.getRowCount(); ++i) {
            int n;
            DataRow row = sheet.getRow(i);
            String prefix = "";
            if (prefixCols.length > 0) {
                for (n = 0; n < prefixCols.length; ++n) {
                    if (n > 0) {
                        prefix = prefix + " ";
                    }
                    prefix = row.hasCell(prefixCols[n]) ? prefix + row.getCell(prefixCols[n]).getContent() : prefix + "?";
                }
                prefix = prefix + " ";
            }
            for (n = 0; n < plotCols.length; ++n) {
                SequencePlotterContainer cont;
                if (xIndex == -1) {
                    cont = new SequencePlotterContainer(prefix + plotNames[n], new Double(i), Double.valueOf(this.getCellValue((Row)row, plotCols[n])));
                } else {
                    if (xIndex == plotCols[n]) continue;
                    if (xIndexString == null) {
                        cont = new SequencePlotterContainer(prefix + plotNames[n], Double.valueOf(this.getCellValue((Row)row, xIndex)), Double.valueOf(this.getCellValue((Row)row, plotCols[n])));
                    } else {
                        if (!xIndexString.containsKey(row.getCell(xIndex).getContent())) {
                            xIndexString.put(row.getCell(xIndex).getContent(), xIndexString.size() + 1);
                        }
                        cont = new SequencePlotterContainer(prefix + plotNames[n], Double.valueOf(((Integer)xIndexString.get(row.getCell(xIndex).getContent())).intValue()), Double.valueOf(this.getCellValue((Row)row, plotCols[n])));
                    }
                }
                result.add(cont);
            }
        }
        return result;
    }
}

