/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories.bookmarks;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.Bookmarks;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.BookmarksEditorPanel;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.BookmarksManagerPanel;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class BookmarksDialog
extends JDialog {
    private static final String MANAGER_PANEL_ID = "MANAGER";
    private static final String EDITOR_PANEL_ID = "EDITOR";
    private static final String MANAGER_DIALOG_TITLE = VFSResources.getMessage("VFSJFileChooser.bookmarksManagerDialogTitle");
    private static final String EDITOR_DIALOG_TITLE = VFSResources.getMessage("VFSJFileChooser.bookmarksEditorDialogTitle");
    private BookmarksManagerPanel managerPanel;
    private BookmarksEditorPanel editorPanel;
    private CardLayout layout = new CardLayout();
    private JPanel cards = new JPanel(this.layout);
    private boolean defaultViewVisible = true;

    public BookmarksDialog(Frame parent, VFSJFileChooser chooser) {
        super(parent, MANAGER_DIALOG_TITLE, true);
        this.saveBookmarksOnWindowClosing();
        this.managerPanel = new BookmarksManagerPanel(this, chooser);
        this.editorPanel = new BookmarksEditorPanel(this, this.managerPanel.getModel());
        this.cards.add((Component)this.managerPanel, MANAGER_PANEL_ID);
        this.cards.add((Component)this.editorPanel, EDITOR_PANEL_ID);
        this.getContentPane().add(this.cards);
        this.pack();
    }

    public Bookmarks getBookmarks() {
        return this.managerPanel.getModel();
    }

    public void showEditorView(int index) {
        this.editorPanel.updateFieds(index);
        this.setTitle(EDITOR_DIALOG_TITLE);
        this.layout.show(this.cards, EDITOR_PANEL_ID);
        this.defaultViewVisible = false;
        this.repaint();
    }

    public void restoreDefaultView() {
        this.setTitle(MANAGER_DIALOG_TITLE);
        this.layout.show(this.cards, MANAGER_PANEL_ID);
        this.defaultViewVisible = true;
        this.repaint();
    }

    protected void saveBookmarksOnWindowClosing() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!BookmarksDialog.this.defaultViewVisible) {
                    BookmarksDialog.this.defaultViewVisible = true;
                    BookmarksDialog.this.setTitle(MANAGER_DIALOG_TITLE);
                    BookmarksDialog.this.layout.show(BookmarksDialog.this.cards, BookmarksDialog.MANAGER_PANEL_ID);
                }
                BookmarksDialog.this.managerPanel.getModel().save();
            }
        });
    }

    public void cancel() {
        this.setVisible(false);
    }
}

