/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.filepane;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileSystemView;
import com.googlecode.vfsjfilechooser2.plaf.VFSFileChooserUIAccessorIF;
import com.googlecode.vfsjfilechooser2.plaf.basic.BasicVFSDirectoryModel;
import com.googlecode.vfsjfilechooser2.utils.FileObjectComparatorFactory;
import com.googlecode.vfsjfilechooser2.utils.SwingCommonsUtilities;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import org.apache.commons.vfs2.FileObject;

public final class VFSFilePane
extends JPanel
implements PropertyChangeListener {
    public static final String ACTION_APPROVE_SELECTION = "approveSelection";
    public static final String ACTION_CANCEL = "cancelSelection";
    public static final String ACTION_EDIT_FILE_NAME = "editFileName";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_CHANGE_TO_PARENT_DIRECTORY = "Go Up";
    public static final String ACTION_NEW_FOLDER = "New Folder";
    public static final String ACTION_VIEW_LIST = "viewTypeList";
    public static final String ACTION_VIEW_DETAILS = "viewTypeDetails";
    public static final String ACTION_VIEW_HIDDEN = "viewHidden";
    public static final int VIEWTYPE_LIST = 0;
    public static final int VIEWTYPE_DETAILS = 1;
    private static final int VIEWTYPE_COUNT = 2;
    private static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private static FocusListener repaintListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent fe) {
            this.repaintSelection(fe.getSource());
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.repaintSelection(fe.getSource());
        }

        private void repaintSelection(Object source) {
            if (source instanceof JList) {
                this.repaintListSelection((JList)source);
            } else if (source instanceof JTable) {
                this.repaintTableSelection((JTable)source);
            }
        }

        private void repaintListSelection(JList list) {
            int[] indices;
            for (int i : indices = list.getSelectedIndices()) {
                Rectangle bounds = list.getCellBounds(i, i);
                list.repaint(bounds);
            }
        }

        private void repaintTableSelection(JTable table) {
            int minRow = table.getSelectionModel().getMinSelectionIndex();
            int maxRow = table.getSelectionModel().getMaxSelectionIndex();
            if (minRow == -1 || maxRow == -1) {
                return;
            }
            int col0 = table.convertColumnIndexToView(0);
            Rectangle first = table.getCellRect(minRow, col0, false);
            Rectangle last = table.getCellRect(maxRow, col0, false);
            Rectangle dirty = first.union(last);
            table.repaint(dirty);
        }
    };
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_SIZE = 1;
    private static final int COLUMN_DATE = 2;
    private JTable detailsTable;
    private Action[] actions;
    private int viewType = -1;
    private JPanel[] viewPanels = new JPanel[2];
    private JPanel currentViewPanel;
    private String[] viewTypeActionNames;
    private JPopupMenu contextMenu;
    private JMenu viewMenu;
    private String viewMenuLabelText;
    private String refreshActionLabelText;
    private String showHiddenFilesLabelText;
    private String newFolderActionLabelText;
    private String renameErrorTitleText;
    private String renameErrorText;
    private String renameErrorFileExistsText;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileDateHeaderText = null;
    private final transient FocusListener editorFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                VFSFilePane.this.applyEdit();
            }
        }
    };
    private boolean smallIconsView = false;
    private Border listViewBorder;
    private Color listViewBackground;
    private boolean listViewWindowsStyle;
    private boolean readOnly;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private DetailsTableModel detailsTableModel;
    private FileObject newFolderFile;
    private VFSFileChooserUIAccessorIF fileChooserUIAccessor;
    private DetailsTableCellEditor tableCellEditor;
    private int lastIndex = -1;
    private FileObject editFile = null;
    private int editX = 20;
    private JTextField editCell = null;
    protected Action newFolderAction;
    private Handler handler;
    private final transient KeyListener detailsKeyListener = new KeyAdapter(){
        private final long timeFactor;
        private final StringBuilder typedString = new StringBuilder();
        private long lastTime = 1000L;
        {
            Long l = (Long)UIManager.get("Table.timeFactor");
            this.timeFactor = l != null ? l : 1000L;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int index;
            BasicVFSDirectoryModel model = VFSFilePane.this.getModel();
            int rowCount = model.getSize();
            if (VFSFilePane.this.detailsTable == null || rowCount == 0 || e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
                return;
            }
            InputMap inputMap = VFSFilePane.this.detailsTable.getInputMap(1);
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
            if (inputMap != null && inputMap.get(key) != null) {
                return;
            }
            int startIndex = VFSFilePane.this.detailsTable.getSelectionModel().getLeadSelectionIndex();
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (startIndex >= rowCount) {
                startIndex = rowCount - 1;
            }
            char c = e.getKeyChar();
            long time = e.getWhen();
            if (time - this.lastTime < this.timeFactor) {
                if (this.typedString.length() == 1 && this.typedString.charAt(0) == c) {
                    ++startIndex;
                } else {
                    this.typedString.append(c);
                }
            } else {
                ++startIndex;
                this.typedString.setLength(0);
                this.typedString.append(c);
            }
            this.lastTime = time;
            if (startIndex >= rowCount) {
                startIndex = 0;
            }
            if ((index = this.getNextMatch(startIndex, rowCount - 1)) < 0 && startIndex > 0) {
                index = this.getNextMatch(0, startIndex - 1);
            }
            if (index >= 0) {
                VFSFilePane.this.detailsTable.getSelectionModel().setSelectionInterval(index, index);
                Rectangle cellRect = VFSFilePane.this.detailsTable.getCellRect(index, VFSFilePane.this.detailsTable.convertColumnIndexToView(0), false);
                VFSFilePane.this.detailsTable.scrollRectToVisible(cellRect);
            }
        }

        private int getNextMatch(int startIndex, int finishIndex) {
            return -1;
        }
    };

    public VFSFilePane(VFSFileChooserUIAccessorIF fileChooserUIAccessor) {
        super(new BorderLayout());
        this.fileChooserUIAccessor = fileChooserUIAccessor;
        this.installDefaults();
        this.createActionMap();
    }

    public void uninstallUI() {
        if (this.getModel() != null) {
            this.getModel().removePropertyChangeListener(this);
        }
    }

    protected VFSJFileChooser getFileChooser() {
        return this.fileChooserUIAccessor.getFileChooser();
    }

    protected BasicVFSDirectoryModel getModel() {
        return this.fileChooserUIAccessor.getModel();
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setViewType(int viewType) {
        JPanel p;
        int oldValue = this.viewType;
        if (viewType == oldValue) {
            return;
        }
        this.viewType = viewType;
        if (viewType == 0) {
            if (this.viewPanels[viewType] == null) {
                p = this.fileChooserUIAccessor.createList();
                if (p == null) {
                    p = this.createList();
                }
                this.setViewPanel(viewType, p);
            }
            this.list.setLayoutOrientation(1);
        } else if (viewType == 1 && this.viewPanels[viewType] == null) {
            p = this.fileChooserUIAccessor.createDetailsView();
            if (p == null) {
                p = this.createDetailsView();
            }
            this.setViewPanel(viewType, p);
        }
        JPanel oldViewPanel = this.currentViewPanel;
        this.currentViewPanel = this.viewPanels[viewType];
        if (this.currentViewPanel != oldViewPanel) {
            if (oldViewPanel != null) {
                this.remove(oldViewPanel);
            }
            this.add((Component)this.currentViewPanel, "Center");
            this.revalidate();
            this.repaint();
        }
        this.updateViewMenu();
        this.firePropertyChange("viewType", oldValue, viewType);
    }

    public void setViewPanel(int viewType, JPanel viewPanel) {
        this.viewPanels[viewType] = viewPanel;
        VFSFilePane.recursivelySetInheritsPopupMenu(viewPanel, true);
        if (viewType == 0) {
            this.list = (JList)this.findChildComponent(this.viewPanels[viewType], JList.class);
            if (this.listSelectionModel == null) {
                this.listSelectionModel = this.list.getSelectionModel();
                if (this.detailsTable != null) {
                    this.detailsTable.setSelectionModel(this.listSelectionModel);
                }
            } else {
                this.list.setSelectionModel(this.listSelectionModel);
            }
        } else if (viewType == 1) {
            this.detailsTable = (JTable)this.findChildComponent(this.viewPanels[viewType], JTable.class);
            this.detailsTable.setRowHeight(Math.max(this.detailsTable.getFont().getSize() + 4, 17));
            if (this.listSelectionModel != null) {
                this.detailsTable.setSelectionModel(this.listSelectionModel);
            }
        }
        if (this.viewType == viewType) {
            if (this.currentViewPanel != null) {
                this.remove(this.currentViewPanel);
            }
            this.currentViewPanel = viewPanel;
            this.add((Component)this.currentViewPanel, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    public Action getViewTypeAction(int viewType) {
        return new ViewTypeAction(viewType);
    }

    private static void recursivelySetInheritsPopupMenu(Container container, boolean b) {
        Component[] components;
        if (container instanceof JComponent) {
            ((JComponent)container).setInheritsPopupMenu(b);
        }
        for (Component component : components = container.getComponents()) {
            VFSFilePane.recursivelySetInheritsPopupMenu((Container)component, b);
        }
    }

    protected void installDefaults() {
        this.listViewBorder = UIManager.getBorder("FileChooser.listViewBorder");
        this.listViewBackground = UIManager.getColor("FileChooser.listViewBackground");
        this.listViewWindowsStyle = UIManager.getBoolean("FileChooser.listViewWindowsStyle");
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        this.viewMenuLabelText = VFSResources.getMessage("VFSJFileChooser.viewMenuLabelText");
        this.refreshActionLabelText = VFSResources.getMessage("VFSJFileChooser.refreshActionLabelText");
        this.showHiddenFilesLabelText = VFSResources.getMessage("VFSJFileChooser.showHiddenFilesLabelText");
        this.newFolderActionLabelText = VFSResources.getMessage("VFSJFileChooser.newFolderActionLabelText");
        this.viewTypeActionNames = new String[2];
        this.viewTypeActionNames[0] = VFSResources.getMessage("VFSJFileChooser.listViewActionLabelText");
        this.viewTypeActionNames[1] = VFSResources.getMessage("VFSJFileChooser.detailsViewActionLabelText");
        this.renameErrorTitleText = VFSResources.getMessage("VFSJFileChooser.renameErrorTitleText");
        this.renameErrorText = VFSResources.getMessage("VFSJFileChooser.renameErrorText");
        this.renameErrorFileExistsText = VFSResources.getMessage("VFSJFileChooser.renameErrorFileExistsText");
        this.fileNameHeaderText = VFSResources.getMessage("VFSJFileChooser.fileNameHeaderText");
        this.fileSizeHeaderText = VFSResources.getMessage("VFSJFileChooser.fileSizeHeaderText");
        this.fileDateHeaderText = VFSResources.getMessage("VFSJFileChooser.fileDateHeaderText");
    }

    public Action[] getActions() {
        if (this.actions == null) {
            ArrayList<Action> actionList = new ArrayList<Action>(8);
            class FilePaneAction
            extends AbstractAction {
                FilePaneAction(String name) {
                    this(name, name);
                }

                FilePaneAction(String name, String cmd) {
                    super(name);
                    this.putValue("ActionCommandKey", cmd);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmd = (String)this.getValue("ActionCommandKey");
                    if (cmd.equals(VFSFilePane.ACTION_CANCEL)) {
                        if (VFSFilePane.this.editFile != null) {
                            VFSFilePane.this.cancelEdit();
                        } else {
                            VFSFilePane.this.getFileChooser().cancelSelection();
                        }
                    } else if (cmd.equals(VFSFilePane.ACTION_EDIT_FILE_NAME)) {
                        VFSJFileChooser fc = VFSFilePane.this.getFileChooser();
                        int index = VFSFilePane.this.listSelectionModel.getMinSelectionIndex();
                        if (!(index < 0 || VFSFilePane.this.editFile != null || fc.isMultiSelectionEnabled() && fc.getSelectedFiles().length > 1)) {
                            VFSFilePane.this.editFileName(index);
                        }
                    } else if (cmd.equals(VFSFilePane.ACTION_REFRESH)) {
                        VFSFilePane.this.getFileChooser().rescanCurrentDirectory();
                    } else if (cmd.equals(VFSFilePane.ACTION_VIEW_HIDDEN)) {
                        VFSFilePane.this.getFileChooser().setFileHidingEnabled(!VFSFilePane.this.getFileChooser().isFileHidingEnabled());
                    }
                }

                @Override
                public boolean isEnabled() {
                    String cmd = (String)this.getValue("ActionCommandKey");
                    if (cmd.equals(VFSFilePane.ACTION_CANCEL)) {
                        return VFSFilePane.this.getFileChooser().isEnabled();
                    }
                    if (cmd.equals(VFSFilePane.ACTION_EDIT_FILE_NAME)) {
                        return !VFSFilePane.this.readOnly && VFSFilePane.this.getFileChooser().isEnabled();
                    }
                    return true;
                }
            }
            actionList.add(new FilePaneAction(ACTION_CANCEL));
            actionList.add(new FilePaneAction(ACTION_EDIT_FILE_NAME));
            FilePaneAction showHidden = new FilePaneAction(this.showHiddenFilesLabelText, ACTION_VIEW_HIDDEN);
            showHidden.putValue("SwingSelectedKey", false);
            actionList.add(showHidden);
            actionList.add(new FilePaneAction(this.refreshActionLabelText, ACTION_REFRESH));
            Action action = this.fileChooserUIAccessor.getApproveSelectionAction();
            if (action != null) {
                actionList.add(action);
            }
            if ((action = this.fileChooserUIAccessor.getChangeToParentDirectoryAction()) != null) {
                actionList.add(action);
            }
            if ((action = this.getNewFolderAction()) != null) {
                actionList.add(action);
            }
            if ((action = this.getViewTypeAction(0)) != null) {
                actionList.add(action);
            }
            this.actions = actionList.toArray(new Action[actionList.size()]);
        }
        return (Action[])this.actions.clone();
    }

    protected void createActionMap() {
        VFSFilePane.addActionsToMap(super.getActionMap(), this.getActions());
    }

    public static void addActionsToMap(ActionMap map, Action[] actions) {
        if (map != null && actions != null) {
            for (Action a : actions) {
                String cmd = (String)a.getValue("ActionCommandKey");
                if (cmd == null) {
                    cmd = (String)a.getValue("Name");
                }
                map.put(cmd, a);
            }
        }
    }

    private void updateListRowCount(JList list) {
        if (this.smallIconsView) {
            list.setVisibleRowCount(this.getModel().getSize() / 3);
        } else {
            list.setVisibleRowCount(-1);
        }
    }

    public JPanel createList() {
        JPanel p = new JPanel(new BorderLayout());
        final VFSJFileChooser fileChooser = this.getFileChooser();
        final JList aList = new JList(){

            @Override
            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null || startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i = startIndex;
                while (backwards ? i >= 0 : i < max) {
                    String filename = fileChooser.getName((FileObject)model.getElementAt(i));
                    if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                        return i;
                    }
                    i += backwards ? -1 : 1;
                }
                return -1;
            }
        };
        aList.setCellRenderer(new FileRenderer());
        aList.setLayoutOrientation(1);
        aList.putClientProperty("List.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            aList.addFocusListener(repaintListener);
        }
        this.updateListRowCount(aList);
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                VFSFilePane.this.updateListRowCount(aList);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                VFSFilePane.this.updateListRowCount(aList);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (VFSFilePane.this.isShowing()) {
                    VFSFilePane.this.clearSelection();
                }
                VFSFilePane.this.updateListRowCount(aList);
            }
        });
        this.getModel().addPropertyChangeListener(this);
        if (fileChooser.isMultiSelectionEnabled()) {
            aList.setSelectionMode(2);
        } else {
            aList.setSelectionMode(0);
        }
        aList.setModel(this.getModel());
        aList.addListSelectionListener(this.createListSelectionListener());
        aList.addMouseListener(this.getMouseHandler());
        JScrollPane scrollpane = new JScrollPane(aList);
        if (this.listViewBackground != null) {
            aList.setBackground(this.listViewBackground);
        }
        if (this.listViewBorder != null) {
            scrollpane.setBorder(this.listViewBorder);
        }
        p.add((Component)scrollpane, "Center");
        return p;
    }

    public ListSelectionListener createListSelectionListener() {
        return this.fileChooserUIAccessor.createListSelectionListener();
    }

    private int getEditIndex() {
        return this.lastIndex;
    }

    private void setEditIndex(int i) {
        this.lastIndex = i;
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.repaint();
        }
    }

    private void editFileName(int index) {
        FileObject currentDirectory = this.getFileChooser().getCurrentDirectoryObject();
        if (this.readOnly || !this.canWrite(currentDirectory)) {
            return;
        }
        this.ensureIndexIsVisible(index);
        switch (this.viewType) {
            case 0: {
                this.editFile = (FileObject)this.getModel().getElementAt(index);
                Rectangle r = this.list.getCellBounds(index, index);
                if (this.editCell == null) {
                    this.editCell = new JTextField();
                    this.editCell.addActionListener(new EditActionListener());
                    this.editCell.addFocusListener(this.editorFocusListener);
                    this.editCell.setNextFocusableComponent(this.list);
                }
                this.list.add(this.editCell);
                this.editCell.setText(this.getFileChooser().getName(this.editFile));
                ComponentOrientation orientation = this.list.getComponentOrientation();
                this.editCell.setComponentOrientation(orientation);
                if (orientation.isLeftToRight()) {
                    this.editCell.setBounds(this.editX + r.x, r.y, r.width - this.editX, r.height);
                } else {
                    this.editCell.setBounds(r.x, r.y, r.width - this.editX, r.height);
                }
                this.editCell.requestFocus();
                this.editCell.selectAll();
                break;
            }
            case 1: {
                this.detailsTable.editCellAt(index, 0);
            }
        }
    }

    private void applyEdit() {
        if (this.editFile != null && VFSUtils.exists(this.editFile)) {
            VFSJFileChooser chooser = this.getFileChooser();
            String oldDisplayName = chooser.getName(this.editFile);
            String oldFileName = this.editFile.getName().getBaseName();
            String newDisplayName = this.editCell.getText().trim();
            if (!newDisplayName.equals(oldDisplayName)) {
                AbstractVFSFileSystemView fsv;
                FileObject f2;
                int i2;
                String newFileName = newDisplayName;
                int i1 = oldFileName.length();
                if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                    newFileName = newDisplayName + oldFileName.substring(i2);
                }
                if (VFSUtils.exists(f2 = (fsv = chooser.getFileSystemView()).createFileObject(VFSUtils.getParentDirectory(this.editFile), newFileName))) {
                    JOptionPane.showMessageDialog(chooser, MessageFormat.format(this.renameErrorFileExistsText, oldFileName), this.renameErrorTitleText, 0);
                } else if (this.getModel().renameFile(this.editFile, f2)) {
                    if (fsv.isParent(chooser.getCurrentDirectoryObject(), f2)) {
                        if (chooser.isMultiSelectionEnabled()) {
                            chooser.setSelectedFileObjects(new FileObject[]{f2});
                        } else {
                            chooser.setSelectedFileObject(f2);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(chooser, MessageFormat.format(this.renameErrorText, oldFileName), this.renameErrorTitleText, 0);
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public Action getNewFolderAction() {
        if (!this.readOnly && this.newFolderAction == null) {
            this.newFolderAction = new AbstractAction(this.newFolderActionLabelText){
                private Action basicNewFolderAction;
                {
                    this.putValue("ActionCommandKey", VFSFilePane.ACTION_NEW_FOLDER);
                    FileObject currentDirectory = VFSFilePane.this.getFileChooser().getCurrentDirectoryObject();
                    if (currentDirectory != null) {
                        this.setEnabled(VFSFilePane.this.canWrite(currentDirectory));
                    }
                }

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (this.basicNewFolderAction == null) {
                        this.basicNewFolderAction = VFSFilePane.this.fileChooserUIAccessor.getNewFolderAction();
                    }
                    VFSJFileChooser fc = VFSFilePane.this.getFileChooser();
                    FileObject oldFile = fc.getSelectedFileObject();
                    this.basicNewFolderAction.actionPerformed(ev);
                    FileObject newFile = fc.getSelectedFileObject();
                    if (newFile != null && !newFile.equals(oldFile) && VFSUtils.isDirectory(newFile)) {
                        VFSFilePane.this.newFolderFile = newFile;
                    }
                }
            };
        }
        return this.newFolderAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            FileObject[] files = this.getFileChooser().getSelectedFileObjects();
            Object[] selectedObjects = this.list.getSelectedValues();
            this.listSelectionModel.setValueIsAdjusting(true);
            try {
                int actuallyIndex;
                int lead = this.listSelectionModel.getLeadSelectionIndex();
                int anchor = this.listSelectionModel.getAnchorSelectionIndex();
                int shouldIndex = 0;
                int fileCount = files.length;
                int selectedFileCount = selectedObjects.length;
                for (actuallyIndex = 0; shouldIndex < fileCount && actuallyIndex < selectedFileCount; ++shouldIndex, ++actuallyIndex) {
                }
                while (shouldIndex < fileCount) {
                    this.doSelectFile(files[shouldIndex++]);
                }
                while (actuallyIndex < selectedFileCount) {
                    this.doDeselectFile(selectedObjects[actuallyIndex++]);
                }
                if (!(this.listSelectionModel instanceof DefaultListSelectionModel)) return;
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(lead);
                this.listSelectionModel.setAnchorSelectionIndex(anchor);
                return;
            }
            finally {
                this.listSelectionModel.setValueIsAdjusting(false);
            }
        } else {
            int i;
            VFSJFileChooser chooser = this.getFileChooser();
            FileObject f = this.isDirectorySelected() ? this.getDirectory() : chooser.getSelectedFileObject();
            if (f != null && (i = this.getModel().indexOf(f)) >= 0) {
                int viewIndex = i;
                this.listSelectionModel.setSelectionInterval(viewIndex, viewIndex);
                this.ensureIndexIsVisible(viewIndex);
                return;
            } else {
                this.clearSelection();
            }
        }
    }

    private void doSelectFile(FileObject fileToSelect) {
        int index = this.getModel().indexOf(fileToSelect);
        if (index >= 0) {
            this.listSelectionModel.addSelectionInterval(index, index);
        }
    }

    private void doDeselectFile(Object fileToDeselect) {
        int index = this.getModel().indexOf(fileToDeselect);
        this.listSelectionModel.removeSelectionInterval(index, index);
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        this.applyEdit();
        FileObject f = (FileObject)e.getNewValue();
        if (f != null) {
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.applyEdit();
        FileObject[] files = (FileObject[])e.getNewValue();
        VFSJFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !VFSUtils.isDirectory(files[0]))) {
            this.setFileSelected();
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        VFSJFileChooser fc = this.getFileChooser();
        AbstractVFSFileSystemView fsv = fc.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        try {
            this.ensureIndexIsVisible(0);
        }
        catch (Exception ex) {
            // empty catch block
        }
        FileObject currentDirectory = fc.getCurrentDirectoryObject();
        if (currentDirectory != null) {
            if (!this.readOnly) {
                this.getNewFolderAction().setEnabled(this.canWrite(currentDirectory));
            }
            this.fileChooserUIAccessor.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
        }
        if (this.list != null) {
            this.list.clearSelection();
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String s;
        if (this.viewType == -1) {
            this.setViewType(0);
        }
        if ((s = e.getPropertyName()).equals("SelectedFileChangedProperty")) {
            this.doSelectedFileChanged(e);
        } else if (s.equals("SelectedFilesChangedProperty")) {
            this.doSelectedFilesChanged(e);
        } else if (s.equals("directoryChanged")) {
            this.doDirectoryChanged(e);
        } else if (s.equals("fileFilterChanged")) {
            this.doFilterChanged(e);
        } else if (s.equals("fileSelectionChanged")) {
            this.doFileSelectionModeChanged(e);
        } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
            this.doMultiSelectionChanged(e);
        } else if (s.equals("CancelSelection")) {
            this.applyEdit();
        } else if (s.equals("busy")) {
            this.setCursor((Boolean)e.getNewValue() != false ? waitCursor : null);
        } else if (s.equals("componentOrientation")) {
            ComponentOrientation o = (ComponentOrientation)e.getNewValue();
            VFSJFileChooser cc = (VFSJFileChooser)e.getSource();
            if (o != e.getOldValue()) {
                cc.applyComponentOrientation(o);
            }
        }
    }

    private void ensureIndexIsVisible(int i) {
        if (i >= 0) {
            if (this.list != null && this.list.getModel().getSize() > i) {
                Rectangle cellBounds = this.list.getCellBounds(i, i);
                if (cellBounds == null) {
                    cellBounds = this.list.getCellBounds(i - 1, i - 1);
                    if (cellBounds != null) {
                        cellBounds.translate(0, 2 * cellBounds.height);
                        this.list.scrollRectToVisible(cellBounds);
                    }
                } else {
                    this.list.ensureIndexIsVisible(i);
                }
            }
            if (this.detailsTable != null) {
                Rectangle r = this.detailsTable.getCellRect(i, 0, true);
                this.detailsTable.scrollRectToVisible(r);
            }
        }
    }

    public void ensureFileIsVisible(VFSJFileChooser fc, FileObject f) {
        int modelIndex = this.getModel().indexOf(f);
        if (modelIndex >= 0) {
            this.ensureIndexIsVisible(modelIndex);
        }
    }

    public void rescanCurrentDirectory() {
        this.getModel().validateFileCache();
    }

    public void clearSelection() {
        if (this.listSelectionModel != null) {
            this.listSelectionModel.clearSelection();
            if (this.listSelectionModel instanceof DefaultListSelectionModel) {
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(0);
                this.listSelectionModel.setAnchorSelectionIndex(0);
            }
        }
    }

    public JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu(this.viewMenuLabelText);
            ButtonGroup viewButtonGroup = new ButtonGroup();
            for (int i = 0; i < 2; ++i) {
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem();
                mi.setAction(new ViewTypeAction(i));
                viewButtonGroup.add(mi);
                this.viewMenu.add(mi);
            }
            this.updateViewMenu();
        }
        return this.viewMenu;
    }

    private void updateViewMenu() {
        if (this.viewMenu != null) {
            Component[] components;
            for (Component component : components = this.viewMenu.getMenuComponents()) {
                JMenuItem mi;
                if (component instanceof JRadioButtonMenuItem) {
                    mi = (JRadioButtonMenuItem)component;
                    if (((ViewTypeAction)mi.getAction()).viewType != this.viewType) continue;
                    mi.setSelected(true);
                    continue;
                }
                if (!(component instanceof JCheckBoxMenuItem) || !(mi = (JCheckBoxMenuItem)component).getActionCommand().equals(ACTION_VIEW_HIDDEN)) continue;
                mi.setSelected(this.getFileChooser().isFileHidingEnabled());
            }
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        JPopupMenu popupMenu = this.getFileChooser().getComponentPopupMenu();
        if (popupMenu != null) {
            return popupMenu;
        }
        JMenu aViewMenu = this.getViewMenu();
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
            if (aViewMenu != null) {
                this.contextMenu.add(aViewMenu);
                if (this.listViewWindowsStyle) {
                    this.contextMenu.addSeparator();
                }
            }
            ActionMap actionMap = this.getActionMap();
            Action refreshAction = actionMap.get(ACTION_REFRESH);
            Action aNewFolderAction = actionMap.get(ACTION_NEW_FOLDER);
            Action showHiddenFiles = actionMap.get(ACTION_VIEW_HIDDEN);
            if (refreshAction != null) {
                this.contextMenu.add(refreshAction);
                if (this.listViewWindowsStyle && aNewFolderAction != null) {
                    this.contextMenu.addSeparator();
                }
            }
            if (showHiddenFiles != null) {
                JCheckBoxMenuItem menuitem = new JCheckBoxMenuItem(showHiddenFiles);
                menuitem.setSelected((Boolean)showHiddenFiles.getValue("SwingSelectedKey"));
                this.contextMenu.add(menuitem);
            }
            if (aNewFolderAction != null) {
                this.contextMenu.add(aNewFolderAction);
            }
        }
        if (aViewMenu != null) {
            aViewMenu.getPopupMenu().setInvoker(aViewMenu);
        }
        return this.contextMenu;
    }

    protected Handler getMouseHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected boolean isDirectorySelected() {
        return this.fileChooserUIAccessor.isDirectorySelected();
    }

    protected FileObject getDirectory() {
        return this.fileChooserUIAccessor.getDirectory();
    }

    private Component findChildComponent(Container container, Class<? extends Object> cls) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            Component c;
            if (cls.isInstance(component)) {
                return component;
            }
            if (!(component instanceof Container) || (c = this.findChildComponent((Container)component, cls)) == null) continue;
            return c;
        }
        return null;
    }

    public boolean canWrite(FileObject f) {
        return VFSUtils.canWrite(f);
    }

    private void updateDetailsColumnModel(JTable table) {
        if (table != null && !this.readOnly && table.getColumnCount() > 0) {
            table.getColumnModel().getColumn(0).setCellEditor(this.getDetailsTableCellEditor());
        }
    }

    private DetailsTableCellEditor getDetailsTableCellEditor() {
        if (this.tableCellEditor == null) {
            this.tableCellEditor = new DetailsTableCellEditor(new JTextField());
        }
        return this.tableCellEditor;
    }

    private DetailsTableModel getDetailsTableModel() {
        if (this.detailsTableModel == null) {
            this.detailsTableModel = new DetailsTableModel(this.getFileChooser());
        }
        return this.detailsTableModel;
    }

    public JPanel createDetailsView() {
        final VFSJFileChooser chooser = this.getFileChooser();
        JPanel p = new JPanel(new BorderLayout());
        JTable detailsTable = new JTable(this.getDetailsTableModel()){

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 27 && this.getCellEditor() == null) {
                    chooser.dispatchEvent(e);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                if (e.getFirstRow() == -1) {
                    VFSFilePane.this.updateDetailsColumnModel(this);
                }
            }
        };
        detailsTable.setAutoCreateColumnsFromModel(false);
        detailsTable.setComponentOrientation(chooser.getComponentOrientation());
        detailsTable.setShowGrid(false);
        detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        Font font = this.list.getFont();
        detailsTable.setFont(font);
        detailsTable.setIntercellSpacing(new Dimension(0, 0));
        AlignableTableHeaderRenderer headerRenderer = new AlignableTableHeaderRenderer(detailsTable.getTableHeader().getDefaultRenderer());
        detailsTable.getTableHeader().setDefaultRenderer(headerRenderer);
        DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer(chooser);
        detailsTable.setDefaultRenderer(Object.class, cellRenderer);
        detailsTable.getColumnModel().getSelectionModel().setSelectionMode(0);
        detailsTable.addMouseListener(this.getMouseHandler());
        detailsTable.putClientProperty("Table.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            detailsTable.addFocusListener(repaintListener);
        }
        JTableHeader header = detailsTable.getTableHeader();
        header.setUpdateTableInRealTime(true);
        header.addMouseListener(this.detailsTableModel.new DetailsTableModel.ColumnListener());
        header.setReorderingAllowed(true);
        ActionMap am = SwingUtilities.getUIActionMap(detailsTable);
        am.remove("selectNextRowCell");
        am.remove("selectPreviousRowCell");
        am.remove("selectNextColumnCell");
        am.remove("selectPreviousColumnCell");
        detailsTable.setFocusTraversalKeys(0, null);
        detailsTable.setFocusTraversalKeys(1, null);
        JScrollPane scrollpane = new JScrollPane(detailsTable);
        scrollpane.setComponentOrientation(chooser.getComponentOrientation());
        LookAndFeel.installColors(scrollpane.getViewport(), "Table.background", "Table.foreground");
        scrollpane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                VFSFilePane.this.fixNameColumnWidth(sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
        });
        scrollpane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JScrollPane jsp = (JScrollPane)e.getComponent();
                JTable table = (JTable)jsp.getViewport().getView();
                if (!e.isShiftDown() || table.getSelectionModel().getSelectionMode() == 0) {
                    VFSFilePane.this.clearSelection();
                    TableCellEditor tce = table.getCellEditor();
                    if (tce != null) {
                        tce.stopCellEditing();
                    }
                }
            }
        });
        detailsTable.setForeground(this.list.getForeground());
        detailsTable.setBackground(this.list.getBackground());
        if (this.listViewBorder != null) {
            scrollpane.setBorder(this.listViewBorder);
        }
        p.add((Component)scrollpane, "Center");
        this.detailsTableModel.fireTableStructureChanged();
        return p;
    }

    private void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailsTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailsTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    static /* synthetic */ String access$2100(VFSFilePane x0) {
        return x0.fileNameHeaderText;
    }

    static /* synthetic */ String access$2200(VFSFilePane x0) {
        return x0.fileSizeHeaderText;
    }

    static /* synthetic */ String access$2300(VFSFilePane x0) {
        return x0.fileDateHeaderText;
    }

    private static class AlignableTableHeaderRenderer
    implements TableCellRenderer {
        TableCellRenderer wrappedRenderer;

        public AlignableTableHeaderRenderer(TableCellRenderer wrappedRenderer) {
            this.wrappedRenderer = wrappedRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                ((JLabel)c).setHorizontalAlignment(0);
            }
            return c;
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        public static final long ONE_KB = 1024L;
        public static final long ONE_MB = 0x100000L;
        public static final long ONE_GB = 0x40000000L;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private VFSJFileChooser chooser;
        private BasicVFSDirectoryModel directoryModel;
        private List<String> columns;
        private final int columnsCount = 3;
        int[] columnMap;
        DateFormat df;
        final String[] headers = new String[]{VFSFilePane.access$2100(VFSFilePane.this), VFSFilePane.access$2200(VFSFilePane.this), VFSFilePane.access$2300(VFSFilePane.this)};

        DetailsTableModel(VFSJFileChooser fc) {
            this.chooser = fc;
            this.directoryModel = VFSFilePane.this.getModel();
            this.directoryModel.addListDataListener(this);
            this.columns = new ArrayList<String>(this.headers.length);
            this.df = DateFormat.getDateTimeInstance(3, 3, this.chooser.getLocale());
            for (String header : this.headers) {
                this.columns.add(header);
            }
            this.updateColumnInfo();
        }

        void updateColumnInfo() {
        }

        @Override
        public int getRowCount() {
            return this.directoryModel.getSize();
        }

        @Override
        public int getColumnCount() {
            return this.columnsCount;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.getFileColumnValue((FileObject)this.directoryModel.getElementAt(row), col);
        }

        private Object getFileColumnValue(FileObject f, int col) {
            Object o = f;
            try {
                switch (col) {
                    case 0: {
                        o = f;
                        break;
                    }
                    case 1: {
                        if (VFSUtils.isDirectory(f)) {
                            o = null;
                            break;
                        }
                        o = Long.parseLong("" + f.getContent().getSize());
                        break;
                    }
                    case 2: {
                        o = f.getContent().getLastModifiedTime() + "";
                        o = new Date(Long.parseLong(o.toString()));
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return o;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                VFSJFileChooser chooser = VFSFilePane.this.getFileChooser();
                FileObject f = (FileObject)this.getValueAt(row, col);
                if (f != null) {
                    String oldDisplayName = chooser.getName(f);
                    String oldFileName = f.getName().getBaseName();
                    String newDisplayName = ((String)value).trim();
                    if (!newDisplayName.equals(oldDisplayName)) {
                        AbstractVFSFileSystemView fsv;
                        FileObject f2;
                        int i2;
                        String newFileName = newDisplayName;
                        int i1 = oldFileName.length();
                        if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                            newFileName = newDisplayName + oldFileName.substring(i2);
                        }
                        if (!VFSUtils.exists(f2 = (fsv = chooser.getFileSystemView()).createFileObject(VFSUtils.getParentDirectory(f), newFileName)) && VFSFilePane.this.getModel().renameFile(f, f2) && fsv.isParent(chooser.getCurrentDirectoryObject(), f2)) {
                            if (chooser.isMultiSelectionEnabled()) {
                                chooser.setSelectedFileObjects(new FileObject[]{f2});
                            } else {
                                chooser.setSelectedFileObject(f2);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            FileObject currentDirectory = VFSFilePane.this.getFileChooser().getCurrentDirectoryObject();
            return !VFSFilePane.this.readOnly && column == 0 && VFSFilePane.this.canWrite(currentDirectory);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            new DelayedSelectionUpdater();
            this.fireTableDataChanged();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            FileObject file;
            int i1;
            int i0 = e.getIndex0();
            if (i0 == (i1 = e.getIndex1()) && (file = (FileObject)VFSFilePane.this.getModel().getElementAt(i0)).getName().equals(VFSFilePane.this.newFolderFile.getName())) {
                new DelayedSelectionUpdater(file);
                VFSFilePane.this.newFolderFile = null;
            }
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public String getColumnName(int column) {
            String str = this.columns.get(column);
            if (column == this.sortCol) {
                str = str + (this.isSortAsc ? " >>" : " <<");
            }
            return str;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        class ColumnListener
        extends MouseAdapter {
            ColumnListener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int columnModelIndex;
                TableColumnModel colModel = VFSFilePane.this.detailsTable.getColumnModel();
                int modelIndex = colModel.getColumn(columnModelIndex = colModel.getColumnIndexAtX(e.getX())).getModelIndex();
                if (modelIndex < 0) {
                    return;
                }
                if (DetailsTableModel.this.sortCol == modelIndex) {
                    DetailsTableModel.this.isSortAsc = !DetailsTableModel.this.isSortAsc;
                } else {
                    DetailsTableModel.this.sortCol = modelIndex;
                }
                for (int i = 0; i < 3; ++i) {
                    TableColumn column = colModel.getColumn(i);
                    column.setHeaderValue(DetailsTableModel.this.getColumnName(column.getModelIndex()));
                }
                VFSFilePane.this.detailsTable.getTableHeader().repaint();
                Comparator<FileObject> cpt = FileObjectComparatorFactory.newFileNameComparator(DetailsTableModel.this.isSortAsc);
                if (modelIndex == 1) {
                    cpt = FileObjectComparatorFactory.newSizeComparator(DetailsTableModel.this.isSortAsc);
                } else if (modelIndex == 2) {
                    cpt = FileObjectComparatorFactory.newDateComparator(DetailsTableModel.this.isSortAsc);
                }
                DetailsTableModel.this.directoryModel.sort(cpt);
                VFSFilePane.this.detailsTable.tableChanged(new TableModelEvent(DetailsTableModel.this));
                VFSFilePane.this.detailsTable.revalidate();
                VFSFilePane.this.detailsTable.repaint();
            }
        }
    }

    private class Handler
    implements MouseListener {
        private MouseListener doubleClickListener;

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int index;
            JComponent source = (JComponent)evt.getSource();
            if (source instanceof JList) {
                index = SwingCommonsUtilities.loc2IndexFileList(VFSFilePane.this.list, evt.getPoint());
            } else if (source instanceof JTable) {
                JTable table = (JTable)source;
                Point p = evt.getPoint();
                index = table.rowAtPoint(p);
                if (SwingCommonsUtilities.pointOutsidePrefSize(table, index, table.columnAtPoint(p), p)) {
                    return;
                }
                if (index >= 0 && VFSFilePane.this.list != null && VFSFilePane.this.listSelectionModel.isSelectedIndex(index)) {
                    Rectangle r = VFSFilePane.this.list.getCellBounds(index, index);
                    evt = new MouseEvent(VFSFilePane.this.list, evt.getID(), evt.getWhen(), evt.getModifiers(), r.x + 1, r.y + r.height / 2, evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
                }
            } else {
                return;
            }
            if (index >= 0 && SwingUtilities.isLeftMouseButton(evt)) {
                VFSJFileChooser fc = VFSFilePane.this.getFileChooser();
                if (evt.getClickCount() == 1 && source instanceof JList) {
                    if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && index >= 0 && VFSFilePane.this.listSelectionModel.isSelectedIndex(index) && VFSFilePane.this.getEditIndex() == index && VFSFilePane.this.editFile == null) {
                        VFSFilePane.this.editFileName(index);
                    } else if (index >= 0) {
                        VFSFilePane.this.setEditIndex(index);
                    } else {
                        VFSFilePane.this.resetEditIndex();
                    }
                } else if (evt.getClickCount() == 2) {
                    VFSFilePane.this.resetEditIndex();
                }
            }
            if (this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            JComponent source = (JComponent)evt.getSource();
            if (source instanceof JTable) {
                boolean dragEnabled;
                TransferHandler th2;
                JTable table = (JTable)evt.getSource();
                TransferHandler th1 = VFSFilePane.this.getFileChooser().getTransferHandler();
                if (th1 != (th2 = table.getTransferHandler())) {
                    table.setTransferHandler(th1);
                }
                if ((dragEnabled = VFSFilePane.this.getFileChooser().getDragEnabled()) != table.getDragEnabled()) {
                    table.setDragEnabled(dragEnabled);
                }
            } else if (source instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseEntered(evt);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseExited(evt);
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mousePressed(evt);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseReleased(evt);
            }
        }

        private MouseListener getDoubleClickListener() {
            if (this.doubleClickListener == null && VFSFilePane.this.list != null) {
                this.doubleClickListener = VFSFilePane.this.fileChooserUIAccessor.createDoubleClickListener(VFSFilePane.this.list);
            }
            return this.doubleClickListener;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            FileObject f = (FileObject)value;
            if (f != null) {
                this.setText(VFSFilePane.this.getFileChooser().getName(f));
                this.setIcon(VFSFilePane.this.getFileChooser().getIcon(f));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            if (cellHasFocus) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VFSFilePane.this.applyEdit();
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        FileObject editFile;

        DelayedSelectionUpdater() {
            this(null);
        }

        DelayedSelectionUpdater(FileObject editFile) {
            this.editFile = editFile;
            if (VFSFilePane.this.isShowing()) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            VFSFilePane.this.setFileSelected();
            if (this.editFile != null) {
                VFSFilePane.this.editFileName(VFSFilePane.this.getModel().indexOf(this.editFile));
                this.editFile = null;
            }
        }
    }

    private class DetailsTableCellEditor
    extends DefaultCellEditor {
        private final JTextField tf;

        public DetailsTableCellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            tf.addFocusListener(VFSFilePane.this.editorFocusListener);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                int index = VFSFilePane.this.detailsTable.rowAtPoint(me.getPoint());
                return me.getClickCount() == 1 && VFSFilePane.this.detailsTable.isRowSelected(index);
            }
            return super.isCellEditable(e);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value instanceof FileObject) {
                this.tf.setText(VFSFilePane.this.getFileChooser().getName((FileObject)value));
                this.tf.selectAll();
            }
            return comp;
        }
    }

    class ViewTypeAction
    extends AbstractAction {
        private int viewType;

        ViewTypeAction(int viewType) {
            super(VFSFilePane.this.viewTypeActionNames[viewType]);
            this.viewType = viewType;
            String cmd = viewType == 0 ? VFSFilePane.ACTION_VIEW_LIST : (viewType == 1 ? VFSFilePane.ACTION_VIEW_DETAILS : (String)this.getValue("Name"));
            this.putValue("ActionCommandKey", cmd);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VFSFilePane.this.setViewType(this.viewType);
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        VFSJFileChooser chooser;
        DateFormat df;

        DetailsTableCellRenderer(VFSJFileChooser chooser) {
            this.chooser = chooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, chooser.getLocale());
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            if (this.getHorizontalAlignment() == 10) {
                width = Math.min(width, this.getPreferredSize().width + 4);
            } else {
                x -= 4;
            }
            super.setBounds(x, y, width, height);
        }

        @Override
        public Insets getInsets(Insets i) {
            i = super.getInsets(i);
            i.left += 4;
            i.right += 4;
            return i;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            if (table.convertColumnIndexToModel(column) != 0 || VFSFilePane.this.listViewWindowsStyle && !table.isFocusOwner()) {
                isSelected = false;
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setIcon(null);
            this.setHorizontalAlignment(2);
            if (value == null) {
                text = "";
            } else if (value instanceof FileObject) {
                FileObject file = (FileObject)value;
                text = this.chooser.getName(file);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (value instanceof Long) {
                long len = (Long)value;
                text = VFSUtils.byteCountToDisplaySize(len);
            } else {
                text = value instanceof Date ? this.df.format((Date)value) : value.toString();
            }
            this.setText(text);
            return this;
        }
    }
}

