/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.utils;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VFSResources {
    private static final String BUNDLE_BASENAME = "com.googlecode.vfsjfilechooser2.i18n.resources";
    private static ResourceBundle resourceBundle;
    private static final Logger LOG;

    private VFSResources() {
        throw new AssertionError((Object)"Cannot create a VFSResources object");
    }

    private static void loadResources() throws MissingResourceException {
        resourceBundle = ResourceBundle.getBundle(BUNDLE_BASENAME);
    }

    public static synchronized void setResourceBundle(ResourceBundle rb) {
        if (rb == null) {
            throw new IllegalArgumentException("ResourceBundle object musn't be null!");
        }
        resourceBundle = rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessage(String messageKey) {
        if (messageKey == null) {
            return null;
        }
        ResourceBundle resourceBundle = VFSResources.resourceBundle;
        synchronized (resourceBundle) {
            String msg = null;
            try {
                msg = VFSResources.resourceBundle.getString(messageKey);
            }
            catch (MissingResourceException ex) {
                msg = messageKey + " Untranslated";
                LOG.log(Level.SEVERE, "Unable to retrieve i18n key", ex);
            }
            return msg;
        }
    }

    static {
        LOG = Logger.getLogger(VFSResources.class.getName());
        try {
            VFSResources.loadResources();
            LOG.log(Level.INFO, "Loaded i18n resources");
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Unable to load i18n resources", ex);
        }
    }
}

