/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseString;
import java.util.ArrayList;

public class ArrayDimensions
extends AbstractBaseString {
    private static final long serialVersionUID = 7100089984419357692L;
    protected int[] m_Dimensions;

    public ArrayDimensions() {
        this("[2]");
    }

    public ArrayDimensions(String s) {
        super(s);
    }

    @Override
    protected String convert(String value) {
        String result = super.convert(value);
        this.m_Dimensions = null;
        return result;
    }

    protected int[] parse(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        while (s.length() > 0) {
            if (s.indexOf(91) == -1 || s.indexOf(93) == -1) {
                return null;
            }
            String part = s.substring(0, s.indexOf(93) + 1);
            if (!part.startsWith("[") || !part.endsWith("]")) {
                return null;
            }
            if (part.length() <= 2) {
                return null;
            }
            parts.add(part.substring(1, part.length() - 1));
            s = s.substring(s.indexOf(93) + 1);
        }
        int[] result = new int[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            try {
                result[i] = Integer.parseInt((String)parts.get(i));
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return result;
    }

    @Override
    public boolean isValid(String value) {
        return this.parse(value) != null;
    }

    public int[] dimensionsValue() {
        if (this.m_Dimensions == null) {
            this.m_Dimensions = this.parse(this.getValue());
        }
        return this.m_Dimensions;
    }

    @Override
    public String getTipText() {
        return "Array dimensions";
    }
}

