/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractRecursiveOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractJavaCodeProducer
extends AbstractRecursiveOptionProducer<String, String> {
    private static final long serialVersionUID = 6441039650955464738L;
    protected StringBuilder m_OutputBuffer;
    protected String m_Copyright;
    protected String m_Package;
    protected String m_SimpleName;
    protected boolean m_OutputDefaultValues;
    protected int m_TmpCounter;

    @Override
    protected String initOutput() {
        return "";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_OutputBuffer = new StringBuilder();
        this.m_Copyright = "University of Waikato, Hamilton, New Zealand";
        this.m_OutputDefaultValues = false;
        this.m_TmpCounter = 0;
        this.m_Package = "adams";
        this.m_SimpleName = "Blah";
    }

    public void setCopyright(String value) {
        this.m_Copyright = value;
    }

    public String getCopyright() {
        return this.m_Copyright;
    }

    public String copyrightTipText() {
        return "The copyright string to add as a comment at the start of the class.";
    }

    public void setOutputDefaultValues(boolean value) {
        this.m_OutputDefaultValues = value;
    }

    public boolean getOutputDefaultValues() {
        return this.m_OutputDefaultValues;
    }

    public String outputDefaultValuesTipText() {
        return "Whether to output default values as well or to suppress them.";
    }

    @Override
    public String getOutput() {
        if (this.m_Output == null) {
            this.m_Output = this.m_OutputBuffer.toString();
        }
        return (String)this.m_Output;
    }

    protected void setSimpleName(String value) {
        this.m_SimpleName = value;
    }

    protected String getSimpleName() {
        return this.m_SimpleName;
    }

    public String simpleNameTipText() {
        return "The simple name of the class (without package prefix).";
    }

    protected void setPackage(String value) {
        this.m_Package = value;
    }

    protected String getPackage() {
        return this.m_Package;
    }

    public String packageTipText() {
        return "The name of the package.";
    }

    protected abstract String getOuterVariableName();

    protected String getCurrentVariable() {
        if (this.m_Nesting.size() == 0) {
            return this.getOuterVariableName();
        }
        return (String)this.m_Nesting.peek();
    }

    protected abstract String getIndentation();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getClassname(Class cls) {
        String name = cls.getName().replace("$", ".");
        if (name.indexOf(".") != -1) return name;
        if (name.equals("byte")) {
            return "byte";
        }
        if (name.equals("short")) {
            return "short";
        }
        if (name.equals("int")) {
            return "Integer";
        }
        if (name.equals("long")) {
            return "Long";
        }
        if (name.equals("float")) {
            return "Float";
        }
        if (name.equals("double")) {
            return "Double";
        }
        if (!name.equals("char")) throw new IllegalStateException("Unhandled primitive: " + name);
        return "Character";
    }

    protected String getClassname(AbstractArgumentOption option) {
        return this.getClassname(option.getBaseClass());
    }

    protected String getClassname(Object obj) {
        return this.getClassname(obj.getClass());
    }

    protected String getCast(AbstractArgumentOption option) {
        String result = this.getClassname(option);
        result = option.isMultiple() ? "(" + result + "[]) " : "(" + result + ") ";
        return result;
    }

    protected String getNextTmpVariable(Class cls) {
        ++this.m_TmpCounter;
        return cls.getSimpleName().toLowerCase() + this.m_TmpCounter;
    }

    @Override
    public String processOption(BooleanOption option) {
        Object currValue = this.getCurrentValue(option);
        if (this.m_OutputDefaultValues || !((Boolean)currValue).equals(option.getDefaultValue())) {
            this.m_OutputBuffer.append(this.getIndentation());
            this.m_OutputBuffer.append(this.getCurrentVariable());
            this.m_OutputBuffer.append(".");
            this.m_OutputBuffer.append(option.getWriteMethod().getName());
            this.m_OutputBuffer.append("(");
            this.m_OutputBuffer.append("" + currValue);
            this.m_OutputBuffer.append(");\n");
            this.m_OutputBuffer.append("\n");
        }
        return null;
    }

    protected boolean isClassName(String s) {
        boolean result;
        try {
            Class.forName(s);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    protected void processClassOption(String variable, Object value) {
        if (value instanceof AbstractActor) {
            this.m_OutputBuffer.append("\n");
            this.m_OutputBuffer.append(this.getIndentation());
            this.m_OutputBuffer.append("// " + ((AbstractActor)value).getFullName() + "\n");
        }
        this.m_OutputBuffer.append(this.getIndentation());
        this.m_OutputBuffer.append(this.getClassname(value));
        this.m_OutputBuffer.append(" ");
        this.m_OutputBuffer.append(variable);
        this.m_OutputBuffer.append(" = new " + this.getClassname(value) + "();\n");
        if (value instanceof OptionHandler) {
            this.m_Nesting.push(variable);
            this.doProduce(((OptionHandler)value).getOptionManager());
            this.m_Nesting.pop();
        } else {
            String[] newArray;
            AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
            String[] array = handler.toArray(value);
            if (array.length > 0 && this.isClassName(array[0])) {
                newArray = new String[array.length - 1];
                System.arraycopy(array, 1, newArray, 0, newArray.length);
            } else {
                newArray = array;
            }
            String options = OptionUtils.joinOptions(newArray).trim();
            if (options.length() > 0) {
                this.m_OutputBuffer.append(this.getIndentation());
                this.m_OutputBuffer.append(variable);
                this.m_OutputBuffer.append(".setOptions(OptionUtils.splitOptions(\"");
                this.m_OutputBuffer.append(Utils.backQuoteChars(options));
                this.m_OutputBuffer.append("\"));\n");
            }
        }
    }

    @Override
    public String processOption(ClassOption option) {
        Object currValue = this.getCurrentValue(option);
        if (this.m_OutputDefaultValues || !this.isDefaultValue(option, currValue) || option.isVariableAttached()) {
            this.m_OutputBuffer.append(this.getIndentation());
            this.m_OutputBuffer.append("argOption = (AbstractArgumentOption) " + this.getCurrentVariable() + ".getOptionManager().findByProperty(\"" + option.getProperty() + "\");\n");
            if (option.isVariableAttached()) {
                this.m_OutputBuffer.append(this.getIndentation());
                this.m_OutputBuffer.append("argOption.setVariable(\"" + option.getVariable() + "\");\n");
            } else {
                String tmp = this.getNextTmpVariable(option.getBaseClass());
                if (option.isMultiple()) {
                    this.m_OutputBuffer.append(this.getIndentation());
                    this.m_OutputBuffer.append(this.getClassname(option) + "[] " + tmp + " = new " + this.getClassname(option) + "[" + Array.getLength(currValue) + "];\n");
                    for (int i = 0; i < Array.getLength(currValue); ++i) {
                        Object value = Array.get(currValue, i);
                        String tmp2 = this.getNextTmpVariable(value.getClass());
                        this.processClassOption(tmp2, value);
                        this.m_OutputBuffer.append(this.getIndentation());
                        this.m_OutputBuffer.append(tmp + "[" + i + "] = ");
                        this.m_OutputBuffer.append(tmp2);
                        this.m_OutputBuffer.append(";\n");
                    }
                    this.m_OutputBuffer.append(this.getIndentation());
                    this.m_OutputBuffer.append(this.getCurrentVariable());
                    this.m_OutputBuffer.append(".");
                    this.m_OutputBuffer.append(option.getWriteMethod().getName());
                    this.m_OutputBuffer.append("(" + tmp + ");\n");
                } else {
                    Object value = currValue;
                    String tmp2 = this.getNextTmpVariable(value.getClass());
                    this.processClassOption(tmp2, value);
                    this.m_OutputBuffer.append(this.getIndentation());
                    this.m_OutputBuffer.append(this.getCurrentVariable());
                    this.m_OutputBuffer.append(".");
                    this.m_OutputBuffer.append(option.getWriteMethod().getName());
                    this.m_OutputBuffer.append("(");
                    this.m_OutputBuffer.append(tmp2);
                    this.m_OutputBuffer.append(");\n");
                }
            }
            this.m_OutputBuffer.append("\n");
        }
        return null;
    }

    @Override
    public String processOption(AbstractArgumentOption option) {
        Object currValue = this.getCurrentValue(option);
        if (this.m_OutputDefaultValues || !this.isDefaultValue(option, currValue) || option.isVariableAttached()) {
            this.m_OutputBuffer.append(this.getIndentation());
            this.m_OutputBuffer.append("argOption = (AbstractArgumentOption) " + this.getCurrentVariable() + ".getOptionManager().findByProperty(\"" + option.getProperty() + "\");\n");
            if (option.isVariableAttached()) {
                this.m_OutputBuffer.append(this.getIndentation());
                this.m_OutputBuffer.append("argOption.setVariable(\"" + option.getVariable() + "\");\n");
            } else {
                String tmp = this.getNextTmpVariable(option.getBaseClass());
                if (option.isMultiple()) {
                    this.m_OutputBuffer.append(this.getIndentation());
                    this.m_OutputBuffer.append(this.getClassname(option) + "[] " + tmp + " = new " + this.getClassname(option) + "[" + Array.getLength(currValue) + "];\n");
                    for (int i = 0; i < Array.getLength(currValue); ++i) {
                        Object value = Array.get(currValue, i);
                        this.m_OutputBuffer.append(this.getIndentation());
                        this.m_OutputBuffer.append(tmp + "[" + i + "] = ");
                        this.m_OutputBuffer.append("(" + this.getClassname(option) + ")");
                        this.m_OutputBuffer.append(" ");
                        this.m_OutputBuffer.append("argOption.valueOf(\"" + option.toString(value).replace("\"", "\\\"") + "\");\n");
                    }
                    this.m_OutputBuffer.append(this.getIndentation());
                    this.m_OutputBuffer.append(this.getCurrentVariable());
                    this.m_OutputBuffer.append(".");
                    this.m_OutputBuffer.append(option.getWriteMethod().getName());
                    this.m_OutputBuffer.append("(" + tmp + ");\n");
                } else {
                    this.m_OutputBuffer.append(this.getIndentation());
                    this.m_OutputBuffer.append(this.getCurrentVariable());
                    this.m_OutputBuffer.append(".");
                    this.m_OutputBuffer.append(option.getWriteMethod().getName());
                    this.m_OutputBuffer.append("(");
                    this.m_OutputBuffer.append(this.getCast(option));
                    this.m_OutputBuffer.append("argOption.valueOf(\"" + option.toString(currValue) + "\"));\n");
                }
            }
            this.m_OutputBuffer.append("\n");
        }
        return null;
    }

    @Override
    protected void preProduce(OptionManager manager, int index) {
        super.preProduce(manager, index);
        this.m_Output = null;
    }

    protected List<String> getRequiredImports() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("adams.env.Environment");
        result.add("adams.core.option.AbstractArgumentOption");
        result.add("adams.core.option.OptionUtils");
        return result;
    }

    protected void addLicensePreamble() {
        this.m_OutputBuffer.append("/*\n");
        this.m_OutputBuffer.append(" *   This program is free software: you can redistribute it and/or modify\n");
        this.m_OutputBuffer.append(" *   it under the terms of the GNU General Public License as published by\n");
        this.m_OutputBuffer.append(" *   the Free Software Foundation, either version 3 of the License, or\n");
        this.m_OutputBuffer.append(" *   (at your option) any later version.\n");
        this.m_OutputBuffer.append(" *\n");
        this.m_OutputBuffer.append(" *   This program is distributed in the hope that it will be useful,\n");
        this.m_OutputBuffer.append(" *   but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
        this.m_OutputBuffer.append(" *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
        this.m_OutputBuffer.append(" *   GNU General Public License for more details.\n");
        this.m_OutputBuffer.append(" *\n");
        this.m_OutputBuffer.append(" *   You should have received a copy of the GNU General Public License\n");
        this.m_OutputBuffer.append(" *   along with this program.  If not, see <http://www.gnu.org/licenses/>.\n");
        this.m_OutputBuffer.append(" */\n");
        this.m_OutputBuffer.append("\n");
    }

    protected void addCopyright() {
        this.m_OutputBuffer.append("/*\n");
        this.m_OutputBuffer.append(" * " + this.m_SimpleName + ".java" + "\n");
        if (this.m_Copyright.length() > 0) {
            SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
            this.m_OutputBuffer.append(" * Copyright (C) " + yearFormatter.format(new Date()) + " " + this.m_Copyright + "\n");
        }
        this.m_OutputBuffer.append(" */\n");
        this.m_OutputBuffer.append("\n");
    }

    protected void addPackage() {
        this.m_OutputBuffer.append("package " + this.m_Package + ";" + "\n");
        this.m_OutputBuffer.append("\n");
    }

    protected void addImports() {
        List<String> imports = this.getRequiredImports();
        for (String imp : imports) {
            this.m_OutputBuffer.append("import " + imp + ";" + "\n");
        }
        this.m_OutputBuffer.append("\n");
    }

    protected void addClassJavadoc() {
        this.m_OutputBuffer.append("/**\n");
        this.m_OutputBuffer.append(" * Code generated for " + this.m_SimpleName + "." + "\n");
        this.m_OutputBuffer.append(" *\n");
        this.m_OutputBuffer.append(" * @author " + System.getProperty("user.name") + "\n");
        this.m_OutputBuffer.append(" * @author " + this.getClass().getName() + " (code generator)" + "\n");
        this.m_OutputBuffer.append(" * @version $Revision: 6358 $\n");
        this.m_OutputBuffer.append(" */\n");
    }

    protected void addClassStart() {
        this.m_OutputBuffer.append("public class " + this.m_SimpleName + " {\n");
        this.m_OutputBuffer.append("\n");
    }

    protected void addConstructor() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Initializes the object.\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public " + this.m_SimpleName + "() {\n");
        this.m_OutputBuffer.append("    super();\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
    }

    protected void addAdditionalMethods() {
    }

    protected abstract void addMethodStart();

    @Override
    protected void preProduce() {
        super.preProduce();
        this.m_TmpCounter = 0;
        this.m_OutputBuffer = new StringBuilder();
        this.addLicensePreamble();
        this.addCopyright();
        this.addPackage();
        this.addImports();
        this.addClassJavadoc();
        this.addClassStart();
        this.addConstructor();
        this.addAdditionalMethods();
        this.addMethodStart();
    }

    protected abstract void addMethodEnd();

    protected void addMainMethod() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Only for testing.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @param args\tignored\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  public static void main(String[] args) {\n");
        this.m_OutputBuffer.append("    Environment.setEnvironmentClass(" + Environment.getEnvironmentClass().getName() + ".class);\n");
        this.m_OutputBuffer.append("    new " + this.m_SimpleName + "();\n");
        this.m_OutputBuffer.append("  }\n");
    }

    protected void addClassEnd() {
        this.m_OutputBuffer.append("}\n");
    }

    @Override
    protected void postProduce() {
        this.addMethodEnd();
        this.addMainMethod();
        this.addClassEnd();
    }

    @Override
    public String toString() {
        return this.getOutput();
    }
}

