/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.base.BaseTime;
import adams.data.conversion.AbstractConversionToString;

public class BaseTimeToString
extends AbstractConversionToString {
    private static final long serialVersionUID = 6744245717394758406L;
    protected BaseTime m_Start;
    protected BaseTime m_End;

    @Override
    public String globalInfo() {
        return "Turns a BaseTime format string into a String, evaluted using user-supplied start and end times (ignored if future INF times).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("start", "start", new BaseTime("-INF"));
        this.m_OptionManager.add("end", "end", new BaseTime("+INF"));
    }

    public void setStart(BaseTime value) {
        this.m_Start = value;
        this.reset();
    }

    public BaseTime getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "The start time to use in the evaluation.";
    }

    public void setEnd(BaseTime value) {
        this.m_End = value;
        this.reset();
    }

    public BaseTime getEnd() {
        return this.m_End;
    }

    public String endTipText() {
        return "The end time to use in the evaluation.";
    }

    @Override
    public Class accepts() {
        return String.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        BaseTime result = new BaseTime((String)this.m_Input);
        if (!this.m_Start.isInfinity()) {
            result.setStart(this.m_Start.dateValue());
        }
        if (!this.m_End.isInfinity()) {
            result.setEnd(this.m_End.dateValue());
        }
        return result.stringValue();
    }
}

