/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.ClassCrossReference;
import adams.core.Utils;
import adams.data.conversion.AbstractStringConversion;
import adams.data.conversion.BackQuote;
import adams.data.conversion.UnBackQuote;
import adams.data.conversion.UnQuote;

public class Quote
extends AbstractStringConversion
implements ClassCrossReference {
    private static final long serialVersionUID = 8391531953153963013L;
    protected QuoteType m_QuoteType;

    @Override
    public String globalInfo() {
        return "Surrounds a string with quotes (single or double), if necessary due to blanks or other characters (new line, tab) in the string.";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{UnQuote.class, BackQuote.class, UnBackQuote.class};
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("quote-type", "quoteType", (Object)QuoteType.DOUBLE);
    }

    public void setQuoteType(QuoteType value) {
        this.m_QuoteType = value;
        this.reset();
    }

    public QuoteType getQuoteType() {
        return this.m_QuoteType;
    }

    public String quoteTypeTipText() {
        return "The type of quote to use.";
    }

    @Override
    protected Object doConvert() throws Exception {
        String input = (String)this.m_Input;
        switch (this.m_QuoteType) {
            case DOUBLE: {
                return Utils.doubleQuote(input);
            }
            case SINGLE: {
                return Utils.quote(input);
            }
        }
        throw new IllegalStateException("Unhandled quote type: " + (Object)((Object)this.m_QuoteType));
    }

    public static enum QuoteType {
        SINGLE,
        DOUBLE;

    }
}

