/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractConversionFromString;
import java.io.File;

public class StringToFile
extends AbstractConversionFromString {
    private static final long serialVersionUID = 8828591710515484463L;
    protected boolean m_CreatePlaceholderFileObjects;
    protected boolean m_MakeCompliant;

    @Override
    public String globalInfo() {
        return "Turns a String into a File object. Optionally, the file name part (excluding the parent path) can be fixed to make it file-system compliant. E.g., ':' is not allowed on MS Windows systems.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("placeholderfile", "createPlaceholderFileObjects", false);
        this.m_OptionManager.add("make-compliant", "makeCompliant", false);
    }

    public void setCreatePlaceholderFileObjects(boolean value) {
        this.m_CreatePlaceholderFileObjects = value;
        this.reset();
    }

    public boolean getCreatePlaceholderFileObjects() {
        return this.m_CreatePlaceholderFileObjects;
    }

    public String createPlaceholderFileObjectsTipText() {
        return "If enabled, PlaceholderFile objects instead of simple File objects are created.";
    }

    public void setMakeCompliant(boolean value) {
        this.m_MakeCompliant = value;
        this.reset();
    }

    public boolean getMakeCompliant() {
        return this.m_MakeCompliant;
    }

    public String makeCompliantTipText() {
        return "If enabled, the file name part of the file (excluding the parent path) is made file-system compliant; compliant characters: abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-.,;()#";
    }

    @Override
    public Class generates() {
        return File.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        File result;
        String input = (String)this.m_Input;
        input = input.startsWith("\\\\") ? "\\\\" + input.substring(2).replace("\\", "/") : input.replace("\\", "/");
        if (this.m_CreatePlaceholderFileObjects) {
            result = new PlaceholderFile(input);
            if (this.m_MakeCompliant) {
                result = new PlaceholderFile(result.getParent() + File.separator + FileUtils.createFilename(result.getName(), "_"));
            }
        } else {
            result = new File(input);
            if (this.m_MakeCompliant) {
                result = new File(result.getParent() + File.separator + FileUtils.createFilename(result.getName(), "_"));
            }
        }
        return result;
    }
}

