/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionHandler;
import adams.data.io.output.AppendableSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.output.WriterOutputStream;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSpreadSheetWriter
extends AbstractOptionHandler {
    private static final long serialVersionUID = -3547064795252689769L;

    public abstract String getFormatDescription();

    public abstract String[] getFormatExtensions();

    protected abstract boolean getUseOutputStream();

    public boolean write(SpreadSheet content, File file) {
        return this.write(content, file.getAbsolutePath());
    }

    public boolean write(SpreadSheet content, String filename) {
        boolean result = true;
        boolean append = false;
        if (this instanceof AppendableSpreadSheetWriter) {
            AppendableSpreadSheetWriter appendable = (AppendableSpreadSheetWriter)((Object)this);
            appendable.setFileExists(FileUtils.fileExists((String)filename));
            append = appendable.canAppend(content);
        }
        try {
            if (this.getUseOutputStream()) {
                FileOutputStream output = new FileOutputStream(filename, append);
                result = this.doWrite(content, output);
                ((OutputStream)output).close();
            } else {
                BufferedWriter writer = new BufferedWriter(new FileWriter(filename, append));
                result = this.doWrite(content, writer);
                writer.close();
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public boolean write(SpreadSheet content, OutputStream stream) {
        if (this.getUseOutputStream()) {
            return this.doWrite(content, stream);
        }
        return this.doWrite(content, new OutputStreamWriter(stream));
    }

    public boolean write(SpreadSheet content, Writer writer) {
        if (this.getUseOutputStream()) {
            return this.doWrite(content, (OutputStream)new WriterOutputStream(writer));
        }
        return this.doWrite(content, writer);
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        return false;
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        return false;
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(AbstractSpreadSheetWriter.class);
    }
}

