/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public abstract class AbstractRow
implements Row {
    private static final long serialVersionUID = -7629759768897079377L;
    protected SpreadSheet m_Owner;
    protected HashMap<String, Cell> m_Cells;

    protected AbstractRow(SpreadSheet owner) {
        this.m_Owner = owner;
        this.m_Cells = new HashMap();
    }

    @Override
    public void setOwner(SpreadSheet owner) {
        this.m_Owner = owner;
    }

    @Override
    public SpreadSheet getOwner() {
        return this.m_Owner;
    }

    @Override
    public void clear() {
        this.m_Cells.clear();
    }

    @Override
    public boolean hasCell(String cellKey) {
        return this.m_Cells.containsKey(cellKey);
    }

    @Override
    public abstract Cell addCell(int var1);

    @Override
    public abstract Cell addCell(String var1);

    @Override
    public Cell removeCell(int columnIndex) {
        return this.removeCell(this.getCellKey(columnIndex));
    }

    @Override
    public Cell removeCell(String cellKey) {
        if (cellKey == null) {
            return null;
        }
        if (!this.hasCell(cellKey)) {
            return null;
        }
        Cell result = this.m_Cells.remove(cellKey);
        return result;
    }

    @Override
    public Cell getCell(String cellKey) {
        return this.m_Cells.get(cellKey);
    }

    @Override
    public Cell getCell(int columnIndex) {
        Cell result = null;
        String key = this.getCellKey(columnIndex);
        if (key != null) {
            result = this.getCell(key);
        }
        return result;
    }

    @Override
    public String getContent(int columnIndex) {
        String result = null;
        String key = this.getCellKey(columnIndex);
        if (key != null) {
            result = this.getCell(key).getContent();
        }
        return result;
    }

    @Override
    public abstract String getCellKey(int var1);

    @Override
    public abstract Collection<String> cellKeys();

    @Override
    public int getCellCount() {
        return this.m_Cells.size();
    }

    @Override
    public boolean removeMissing() {
        boolean result = false;
        ArrayList<String> list = new ArrayList<String>(this.m_Cells.keySet());
        for (String key : list) {
            if (!this.getCell(key).isMissing()) continue;
            this.removeCell(key);
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.m_Cells.toString();
    }
}

