/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.data.spreadsheet.AbstractRow;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class HeaderRow
extends AbstractRow {
    private static final long serialVersionUID = 6495559418329338208L;
    protected ArrayList<String> m_CellKeys = new ArrayList();

    protected HeaderRow(SpreadSheet owner) {
        super(owner);
    }

    @Override
    public HeaderRow getClone(SpreadSheet owner) {
        HeaderRow result = new HeaderRow(owner);
        result.m_CellKeys.addAll(this.m_CellKeys);
        for (int i = 0; i < this.m_CellKeys.size(); ++i) {
            Cell cell = new Cell(result);
            cell.assign((Cell)this.m_Cells.get(this.m_CellKeys.get(i)));
            result.m_Cells.put(result.m_CellKeys.get(i), cell);
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.m_CellKeys.clear();
    }

    @Override
    public boolean hasCell(int columnIndex) {
        return this.hasCell(this.getCellKey(columnIndex));
    }

    public int indexOf(String cellKey) {
        return this.m_CellKeys.indexOf(cellKey);
    }

    @Override
    public Cell addCell(int columnIndex) {
        return this.addCell(this.getCellKey(columnIndex));
    }

    @Override
    public Cell addCell(String cellKey) {
        Cell result;
        if (this.hasCell(cellKey)) {
            result = this.getCell(cellKey);
        } else {
            result = new Cell(this);
            this.m_CellKeys.add(cellKey);
            this.m_Cells.put(cellKey, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell insertCell(int columnIndex) {
        Cell result = new Cell(this);
        HashMap hashMap = this.m_Cells;
        synchronized (hashMap) {
            ArrayList<String> arrayList = this.m_CellKeys;
            synchronized (arrayList) {
                String col;
                int i = 0;
                while (this.hasCell(col = "inserted-" + ++i)) {
                }
                this.m_CellKeys.add(columnIndex, col);
                this.m_Cells.put(col, result);
            }
        }
        return result;
    }

    @Override
    public Cell removeCell(String cellKey) {
        Cell result = super.removeCell(cellKey);
        if (result == null) {
            return null;
        }
        this.m_CellKeys.remove(cellKey);
        return result;
    }

    @Override
    public String getCellKey(int columnIndex) {
        if (columnIndex < this.m_CellKeys.size()) {
            return this.m_CellKeys.get(columnIndex);
        }
        return null;
    }

    @Override
    public Collection<String> cellKeys() {
        return Collections.unmodifiableCollection(this.m_CellKeys);
    }

    @Override
    public Collection<Cell> cells() {
        ArrayList<Cell> result = new ArrayList<Cell>();
        for (String key : this.m_CellKeys) {
            result.add((Cell)this.m_Cells.get(key));
        }
        return result;
    }

    @Override
    public int indexOf(Cell cell) {
        int result = -1;
        if (cell.getOwner() == this && this.m_Cells.containsValue(cell)) {
            for (int i = 0; i < this.m_CellKeys.size(); ++i) {
                String key = this.m_CellKeys.get(i);
                if (this.m_Cells.get(key) != cell) continue;
                result = i;
                break;
            }
        }
        return result;
    }
}

