/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Utils;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import java.io.Serializable;
import java.util.Comparator;

public class RowComparator
implements Serializable,
Comparator<Row> {
    private static final long serialVersionUID = 7477661638560986045L;
    protected int[] m_Indices;
    protected boolean[] m_Ascending;

    public RowComparator(int[] indices) {
        this(indices, null);
    }

    public RowComparator(int[] indices, boolean[] ascending) {
        if (indices == null) {
            throw new IllegalArgumentException("Indices cannot be null!");
        }
        if (ascending == null) {
            ascending = new boolean[indices.length];
        }
        if (indices.length != ascending.length) {
            throw new IllegalArgumentException("Length of indices and sorting order differ: " + indices.length + " != " + ascending.length);
        }
        this.m_Indices = (int[])indices.clone();
        this.m_Ascending = (boolean[])ascending.clone();
    }

    public int[] getIndices() {
        return this.m_Indices;
    }

    public boolean[] getAscending() {
        return this.m_Ascending;
    }

    @Override
    public int compare(Row o1, Row o2) {
        int result = 0;
        HeaderRow header = o1.getOwner().getHeaderRow();
        for (int i = 0; result == 0 && i < this.m_Indices.length; ++i) {
            String key = header.getCellKey(this.m_Indices[i]);
            Cell cell1 = o1.getCell(key);
            Cell cell2 = o2.getCell(key);
            result = cell1 == null && cell2 == null ? 0 : (cell1 == null ? -1 : (cell2 == null ? 1 : (cell1.isMissing() && cell2.isMissing() ? 0 : (cell1.isMissing() ? -1 : (cell2.isMissing() ? 1 : (cell1.isNumeric() && cell2.isNumeric() ? cell1.toDouble().compareTo(cell2.toDouble()) : (cell1.isDate() && cell2.isDate() ? cell1.toDate().compareTo(cell2.toDate()) : (cell1.isTime() && cell2.isTime() ? cell1.toTime().compareTo(cell2.toTime()) : cell1.getContent().compareTo(cell2.getContent())))))))));
            if (this.m_Ascending[i]) continue;
            result = -result;
        }
        return result;
    }

    public String toString() {
        return "indices=" + Utils.arrayToString(this.m_Indices) + ", asc=" + Utils.arrayToString(this.m_Ascending);
    }
}

