/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.ClassLocator;
import adams.core.CloneHandler;
import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Utils;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SharedStringsTable;
import adams.event.SpreadSheetColumnInsertionEvent;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;

public class SpreadSheet
implements Serializable,
CloneHandler<SpreadSheet> {
    private static final long serialVersionUID = -5500678849412481001L;
    public static final String COMMENT = "#";
    public static final String MISSING_VALUE = "?";
    protected ArrayList<String> m_RowKeys = new ArrayList();
    protected HashMap<String, DataRow> m_Rows = new HashMap();
    protected HeaderRow m_HeaderRow = new HeaderRow(this);
    protected List<String> m_Comments = new ArrayList<String>();
    protected String m_Name = null;
    protected DateFormat m_DateFormat = DateUtils.getDateFormatter();
    protected DateFormat m_DateTimeFormat = DateUtils.getTimestampFormatter();
    protected DateFormat m_TimeFormat = DateUtils.getTimeFormatter();
    protected SharedStringsTable m_StringsTable = new SharedStringsTable();
    protected Class m_DataRowClass = DenseDataRow.class;

    public void setDataRowClass(Class cls) {
        if (cls == null) {
            cls = DenseDataRow.class;
        }
        if (!ClassLocator.hasInterface(DataRow.class, cls)) {
            throw new IllegalArgumentException("Data row class " + cls.getName() + " does not implement " + DataRow.class.getName() + "!");
        }
        this.m_DataRowClass = cls;
    }

    public Class getDataRowClass() {
        return this.m_DataRowClass;
    }

    @Override
    public SpreadSheet getClone() {
        SpreadSheet result = new SpreadSheet();
        result.m_StringsTable.assign(this.m_StringsTable);
        result.m_DataRowClass = this.m_DataRowClass;
        result.m_HeaderRow = this.m_HeaderRow.getClone(result);
        result.m_Comments.addAll(this.m_Comments);
        result.m_RowKeys.addAll(this.m_RowKeys);
        for (int i = 0; i < this.m_RowKeys.size(); ++i) {
            DataRow row = this.m_Rows.get(this.m_RowKeys.get(i)).getClone(result);
            result.m_Rows.put(this.m_RowKeys.get(i), row);
        }
        return result;
    }

    public SpreadSheet getHeader() {
        SpreadSheet result = new SpreadSheet();
        result.m_HeaderRow = this.m_HeaderRow.getClone(result);
        result.m_HeaderRow.setOwner(result);
        result.m_DataRowClass = this.m_DataRowClass;
        result.m_Comments.addAll(this.m_Comments);
        return result;
    }

    public DateFormat getDateFormat() {
        return this.m_DateFormat;
    }

    public DateFormat getDateTimeFormat() {
        return this.m_DateTimeFormat;
    }

    public DateFormat getTimeFormat() {
        return this.m_TimeFormat;
    }

    public void setName(String value) {
        this.m_Name = value;
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean hasName() {
        return this.m_Name != null;
    }

    public void addComment(String comment) {
        this.m_Comments.add(comment);
    }

    public List<String> getComments() {
        return this.m_Comments;
    }

    public void clear() {
        this.m_RowKeys.clear();
        this.m_Rows.clear();
        this.m_StringsTable.clear();
    }

    public HeaderRow getHeaderRow() {
        return this.m_HeaderRow;
    }

    public List<String> getColumnNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            result.add(this.getHeaderRow().getCell(i).getContent());
        }
        return result;
    }

    public boolean hasRow(int rowIndex) {
        return rowIndex >= 0 && rowIndex < this.m_Rows.size();
    }

    public boolean hasRow(String rowKey) {
        return this.m_Rows.containsKey(rowKey);
    }

    protected synchronized DataRow newRow() {
        DataRow result;
        try {
            Constructor constr = this.m_DataRowClass.getConstructor(SpreadSheet.class);
            result = (DataRow)constr.newInstance(this);
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate data row class: " + this.m_DataRowClass.getName());
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public DataRow addRow() {
        int i = this.getRowCount();
        while (this.hasRow("" + i)) {
            ++i;
        }
        return this.addRow("" + i);
    }

    public DataRow addRow(String rowKey) {
        DataRow result;
        if (this.hasRow(rowKey)) {
            result = this.getRow(rowKey);
        } else {
            this.m_RowKeys.add(rowKey);
            this.m_Rows.put(rowKey, this.newRow());
            result = this.m_Rows.get(rowKey);
        }
        return result;
    }

    public DataRow insertRow(int index) {
        String rowKey;
        int i = 0;
        while (this.hasRow(rowKey = "inserted-" + ++i)) {
        }
        DataRow result = this.newRow();
        this.m_RowKeys.add(index, rowKey);
        this.m_Rows.put(rowKey, result);
        return result;
    }

    public Row removeRow(int rowIndex) {
        return this.removeRow(this.getRowKey(rowIndex));
    }

    public Row removeRow(String rowKey) {
        if (rowKey == null) {
            return null;
        }
        if (!this.hasRow(rowKey)) {
            return null;
        }
        this.m_RowKeys.remove(rowKey);
        Row result = this.m_Rows.remove(rowKey);
        return result;
    }

    public void insertColumn(int columnIndex, String header) {
        this.insertColumn(columnIndex, header, null);
    }

    public void insertColumn(int columnIndex, String header, String initial) {
        this.getHeaderRow().insertCell(columnIndex).setContent(header);
        SpreadSheetColumnInsertionEvent e = new SpreadSheetColumnInsertionEvent(this, columnIndex);
        String key = this.getHeaderRow().getCellKey(columnIndex);
        for (DataRow row : this.rows()) {
            row.spreadSheetColumnInserted(e);
            if (initial == null) continue;
            row.addCell(key).setContent(initial);
        }
    }

    public boolean removeColumn(int columnIndex) {
        return this.removeColumn(this.getHeaderRow().getCellKey(columnIndex));
    }

    public boolean removeColumn(String columnKey) {
        if (!this.getHeaderRow().hasCell(columnKey)) {
            return false;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.getRow(i).removeCell(columnKey);
        }
        this.getHeaderRow().removeCell(columnKey);
        return true;
    }

    public DataRow getRow(String rowKey) {
        return this.m_Rows.get(rowKey);
    }

    public DataRow getRow(int rowIndex) {
        return this.m_Rows.get(this.m_RowKeys.get(rowIndex));
    }

    public String getRowKey(int rowIndex) {
        return this.m_RowKeys.get(rowIndex);
    }

    public int getRowIndex(String rowKey) {
        int result = -1;
        for (int i = 0; i < this.m_RowKeys.size(); ++i) {
            if (!this.m_RowKeys.get(i).equals(rowKey)) continue;
            result = i;
            break;
        }
        return result;
    }

    public int getCellIndex(String cellKey) {
        int result = -1;
        for (int i = 0; i < this.m_HeaderRow.getCellCount(); ++i) {
            if (!this.m_HeaderRow.getCellKey(i).equals(cellKey)) continue;
            result = i;
            break;
        }
        return result;
    }

    public boolean hasCell(String rowKey, String cellKey) {
        boolean result = this.hasRow(rowKey);
        if (result) {
            DataRow row = this.getRow(rowKey);
            result = row.hasCell(cellKey);
        }
        return result;
    }

    public boolean hasCell(int rowIndex, int columnIndex) {
        boolean result = this.hasRow(rowIndex);
        if (result) {
            DataRow row = this.getRow(rowIndex);
            result = row.hasCell(columnIndex);
        }
        return result;
    }

    public Cell getCell(String rowKey, String cellKey) {
        Cell result = null;
        DataRow row = this.getRow(rowKey);
        if (row != null) {
            result = row.getCell(cellKey);
        }
        return result;
    }

    public Cell getCell(int rowIndex, int columnIndex) {
        Cell result = null;
        DataRow row = this.getRow(rowIndex);
        if (row != null) {
            result = row.getCell(columnIndex);
        }
        return result;
    }

    public static String getColumnPosition(int col) {
        List<Integer> digits;
        String result = null;
        if (col >= 321272406) {
            throw new IllegalArgumentException("Column of cell too large: " + col + " >= " + 321272406);
        }
        result = "";
        if (col < 26) {
            digits = Utils.toBase(col, 26);
        } else if (col < 702) {
            digits = Utils.toBase(col - 26, 26);
            while (digits.size() < 2) {
                digits.add(0);
            }
        } else if (col < 18278) {
            digits = Utils.toBase(col - 26 - 676, 26);
            while (digits.size() < 3) {
                digits.add(0);
            }
        } else if (col < 475254) {
            digits = Utils.toBase(col - 26 - 676 - 17576, 26);
            while (digits.size() < 4) {
                digits.add(0);
            }
        } else if (col < 12356630) {
            digits = Utils.toBase(col - 26 - 676 - 17576 - 456976, 26);
            while (digits.size() < 5) {
                digits.add(0);
            }
        } else {
            digits = Utils.toBase(col - 26 - 676 - 17576 - 456976 - 11881376, 26);
            while (digits.size() < 6) {
                digits.add(0);
            }
        }
        for (int i = digits.size() - 1; i >= 0; --i) {
            result = result + (char)(65 + digits.get(i));
        }
        return result;
    }

    public String getCellPosition(String rowKey, String cellKey) {
        int rowIndex = this.getRowIndex(rowKey);
        int cellIndex = this.getCellIndex(cellKey);
        return SpreadSheet.getCellPosition(rowIndex + 1, cellIndex);
    }

    public static String getCellPosition(int row, int col) {
        String result = SpreadSheet.getColumnPosition(col);
        if (row == -1 || col == -1) {
            return result;
        }
        result = result + (row + 2);
        return result;
    }

    public static int[] getCellLocation(String position) throws Exception {
        int i;
        int[] result = new int[2];
        boolean isCol = true;
        String row = "";
        String col = "";
        for (i = 0; i < position.length(); ++i) {
            char chr = position.charAt(i);
            if (chr >= '0' && chr <= '9') {
                isCol = false;
                row = row + chr;
                continue;
            }
            if (chr >= 'A' && chr <= 'Z' && isCol) {
                col = col + chr;
                continue;
            }
            throw new Exception("Invalid character in cell position string: " + chr);
        }
        result[0] = Integer.parseInt(row) - 2;
        int factor = 1;
        for (i = col.length() - 1; i >= 0; --i) {
            result[1] = result[1] + (col.charAt(i) - 65 + 1) * factor;
            factor *= 26;
        }
        result[1] = result[1] - 1;
        return result;
    }

    public Collection<String> rowKeys() {
        return Collections.unmodifiableCollection(this.m_RowKeys);
    }

    public Collection<DataRow> rows() {
        ArrayList<DataRow> result = new ArrayList<DataRow>();
        for (String key : this.m_RowKeys) {
            result.add(this.m_Rows.get(key));
        }
        return result;
    }

    public void sort() {
        Collections.sort(this.m_RowKeys);
    }

    public void sort(Comparator<String> comp) {
        Collections.sort(this.m_RowKeys, comp);
    }

    public void sort(int index, boolean asc) {
        this.sort(new RowComparator(new int[]{index}, new boolean[]{asc}));
    }

    public void sort(RowComparator comp) {
        ArrayList<DataRow> list = new ArrayList<DataRow>();
        for (String key : this.m_RowKeys) {
            list.add(this.m_Rows.get(key));
        }
        Collections.sort(list, comp);
        this.m_Rows.clear();
        this.m_RowKeys.clear();
        for (DataRow row : list) {
            String rkey = "" + this.m_Rows.size();
            this.m_Rows.put(rkey, row);
            this.m_RowKeys.add(rkey);
        }
    }

    public int getColumnCount() {
        return this.getHeaderRow().getCellCount();
    }

    public int getRowCount() {
        return this.m_RowKeys.size();
    }

    public boolean isNumeric(int columnIndex) {
        boolean result = false;
        Collection<Cell.ContentType> found = this.getContentTypes(columnIndex);
        if (found.size() > 0) {
            found.remove((Object)Cell.ContentType.DOUBLE);
            found.remove((Object)Cell.ContentType.LONG);
            result = found.size() == 0;
        }
        return result;
    }

    public boolean isContentType(int columnIndex, Cell.ContentType type) {
        Cell.ContentType found = this.getContentType(columnIndex);
        boolean result = found == type;
        return result;
    }

    public Cell.ContentType getContentType(int columnIndex) {
        Cell.ContentType result = null;
        Collection<Cell.ContentType> types = this.getContentTypes(columnIndex);
        if (types.size() == 1) {
            result = (Cell.ContentType)((Object)types.toArray()[0]);
        }
        return result;
    }

    public Collection<Cell.ContentType> getContentTypes(int columnIndex) {
        HashSet<Cell.ContentType> results = new HashSet<Cell.ContentType>();
        String colKey = this.m_HeaderRow.getCellKey(columnIndex);
        for (int i = 0; i < this.getRowCount(); ++i) {
            Cell cell = this.getRow(i).getCell(colKey);
            if (cell == null || cell.isMissing()) continue;
            results.add(cell.getContentType());
        }
        return results;
    }

    public String equalsHeader(SpreadSheet other) {
        String result = null;
        if (other == null) {
            return result;
        }
        HeaderRow header = this.getHeaderRow();
        HeaderRow otherHeader = other.getHeaderRow();
        if (header.getCellCount() != otherHeader.getCellCount()) {
            result = "Number of columns differ: " + header.getCellCount() + " != " + otherHeader.getCellCount();
        }
        if (result == null) {
            for (int i = 0; i < header.getCellCount(); ++i) {
                if (header.getCell(i).getContent().equals(otherHeader.getCell(i).getContent())) continue;
                result = "Column header #" + (i + 1) + " differs: " + header.getCell(i).getContent() + " != " + otherHeader.getCell(i).getContent();
                break;
            }
        }
        return result;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        new CsvSpreadSheetWriter().write(this, writer);
        return writer.toString();
    }

    public Object[][] toMatrix() {
        int i;
        Object[][] result = new Object[this.getRowCount() + 1][this.getColumnCount()];
        Row row = this.getHeaderRow();
        for (i = 0; i < this.getColumnCount(); ++i) {
            if (row.getCell(i).isMissing()) continue;
            result[0][i] = row.getCell(i).getContent();
        }
        for (int n = 0; n < this.getRowCount(); ++n) {
            row = this.getRow(n);
            for (i = 0; i < this.getColumnCount(); ++i) {
                Cell cell;
                String key = this.getHeaderRow().getCellKey(i);
                if (!row.hasCell(key) || (cell = row.getCell(i)).isMissing()) continue;
                result[n + 1][i] = cell.isNumeric() ? row.getCell(i).toDouble() : row.getCell(i).getContent();
            }
        }
        return result;
    }

    public boolean removeMissing() {
        boolean result = false;
        for (DataRow row : this.m_Rows.values()) {
            result |= row.removeMissing();
        }
        return result;
    }

    public SharedStringsTable getSharedStringsTable() {
        return this.m_StringsTable;
    }

    public void setDateLenient(boolean value) {
        this.m_DateFormat.setLenient(value);
    }

    public boolean isDateLenient() {
        return this.m_DateFormat.isLenient();
    }

    public void setDateTimeLenient(boolean value) {
        this.m_DateTimeFormat.setLenient(value);
    }

    public boolean isDateTimeLenient() {
        return this.m_DateTimeFormat.isLenient();
    }

    public void setTimeLenient(boolean value) {
        this.m_TimeFormat.setLenient(value);
    }

    public boolean isTimeLenient() {
        return this.m_TimeFormat.isLenient();
    }

    public void setTimeZone(TimeZone value) {
        this.m_DateFormat.setTimeZone(value);
        this.m_TimeFormat.setTimeZone(value);
    }

    public TimeZone getTimeZone() {
        return this.m_DateFormat.getTimeZone();
    }

    public void calculate() {
        for (DataRow row : this.rows()) {
            for (Cell cell : row.cells()) {
                if (!cell.isFormula()) continue;
                cell.calculate();
            }
        }
    }
}

