/*
 * Decompiled with CFR 0.152.
 */
package adams.data.utils;

import adams.core.Utils;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;

public class SavitzkyGolay {
    public static double[] determineCoefficients(int numLeft, int numRight, int polyOrder, int derOrder) {
        return SavitzkyGolay.determineCoefficients(numLeft, numRight, polyOrder, derOrder, false);
    }

    public static double[] determineCoefficients(int numLeft, int numRight, int polyOrder, int derOrder, boolean debug) {
        float sum;
        int j;
        int i;
        double[] result = new double[numLeft + numRight + 1];
        if (result.length == 1) {
            result[0] = 1.0;
            return result;
        }
        Array2DRowRealMatrix A = new Array2DRowRealMatrix(polyOrder + 1, polyOrder + 1);
        for (i = 0; i < A.getRowDimension(); ++i) {
            for (j = 0; j < A.getColumnDimension(); ++j) {
                sum = 0.0f;
                for (int k = -numLeft; k <= numRight; ++k) {
                    sum = (float)((double)sum + Math.pow(k, i + j));
                }
                A.setEntry(i, j, (double)sum);
            }
        }
        if (debug) {
            System.out.println("A:\n" + A);
        }
        Array2DRowRealMatrix b = new Array2DRowRealMatrix(polyOrder + 1, 1);
        b.setEntry(derOrder, 0, 1.0);
        if (debug) {
            System.out.println("b:\n" + b);
        }
        LUDecompositionImpl lu = new LUDecompositionImpl((RealMatrix)A);
        RealMatrix solution = lu.getSolver().solve((RealMatrix)b);
        if (debug) {
            System.out.println("LU decomp. - solution:\n" + solution);
        }
        for (i = -numLeft; i <= numRight; ++i) {
            sum = 0.0f;
            for (j = 0; j <= polyOrder; ++j) {
                sum = (float)((double)sum + solution.getEntry(j, 0) * Math.pow(i, j));
            }
            result[i + numLeft] = sum;
        }
        if (debug) {
            System.out.println("Coefficients:\n" + Utils.arrayToString(result));
        }
        return result;
    }
}

