/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.io.PlaceholderFile;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public abstract class AbstractScriptCondition
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -1266048092842841686L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", "");
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ScriptObject = null;
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("scriptFile");
        if (variable != null) {
            return variable;
        }
        return new String(this.m_ScriptFile + " " + this.m_ScriptOptions).trim();
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
    }

    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp(AbstractActor owner) {
        String result = super.setUp(owner);
        if (result == null) {
            result = this.initScriptObject();
        }
        return result;
    }

    protected abstract boolean doScriptEvaluate(AbstractActor var1, Token var2);

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        String msg;
        if (this.m_ScriptObject == null && (msg = this.initScriptObject()) != null) {
            throw new IllegalStateException(msg);
        }
        return this.doScriptEvaluate(owner, token);
    }
}

