/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.flow.condition.bool.AbstractMultiCondition;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class Or
extends AbstractMultiCondition {
    private static final long serialVersionUID = -7930281929775307418L;

    @Override
    public String globalInfo() {
        return "Performs a logical OR over all its sub-conditions, i.e., it evaluates to 'true' if any of the sub-conditions evaluates to 'true' as well.";
    }

    @Override
    public String conditionsTipText() {
        return "The conditions to use for the logical OR.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected boolean doEvaluate(AbstractActor owner, Token token) {
        boolean result = false;
        for (BooleanCondition condition : this.m_Conditions) {
            if (!condition.evaluate(owner, token)) continue;
            result = true;
            break;
        }
        return result;
    }
}

