/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Variables;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.InstantiatableActor;

public abstract class AbstractInstantiatableActor
extends AbstractActor
implements InstantiatableActor,
ActorHandler {
    private static final long serialVersionUID = 1979504358437781588L;
    protected AbstractActor m_BaseActor;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actor", this.getDefaultActor());
    }

    protected abstract AbstractActor getDefaultActor();

    public void setActor(AbstractActor value) {
        this.m_BaseActor = value;
        this.m_BaseActor.setParent(this);
        this.reset();
    }

    public AbstractActor getActor() {
        return this.m_BaseActor;
    }

    public abstract String actorTipText();

    @Override
    public String check() {
        return null;
    }

    @Override
    protected boolean canInspectOptions(Class cls) {
        if (cls == AbstractActor.class) {
            return false;
        }
        return super.canInspectOptions(cls);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AbstractActor get(int index) {
        if (index == 0) {
            return this.m_BaseActor;
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index != 0) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        this.m_BaseActor = actor;
    }

    @Override
    public int indexOf(String actor) {
        if (actor.equals(this.m_BaseActor.getName())) {
            return 0;
        }
        return -1;
    }

    @Override
    public AbstractActor firstActive() {
        if (!this.m_BaseActor.getSkip()) {
            return this.m_BaseActor;
        }
        return null;
    }

    @Override
    public AbstractActor lastActive() {
        if (!this.m_BaseActor.getSkip()) {
            return this.m_BaseActor;
        }
        return null;
    }

    @Override
    protected void forceVariables(Variables value) {
        super.forceVariables(value);
        this.m_BaseActor.setVariables(value);
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_BaseActor.setUp();
        }
        return result;
    }

    @Override
    protected String doExecute() {
        return this.m_BaseActor.execute();
    }

    @Override
    public void wrapUp() {
        this.m_BaseActor.wrapUp();
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        this.m_BaseActor.cleanUp();
        super.cleanUp();
    }
}

