/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.VariableName;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.ControlActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.ComponentSupplier;
import adams.gui.print.JComponentWriter;
import adams.gui.print.NullWriter;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public class GlobalActorScreenshot
extends AbstractActor
implements ControlActor,
InputConsumer,
OutputProducer {
    private static final long serialVersionUID = -7346814880631564292L;
    public static final String BACKUP_COUNTER = "counter";
    public static final String BACKUP_INPUT = "input";
    protected GlobalActorReference m_GlobalName;
    protected Token m_InputToken;
    protected Token m_OutputToken;
    protected JComponentWriter m_Writer;
    protected PlaceholderDirectory m_OutputDir;
    protected String m_FilenamePrefix;
    protected VariableName m_FilenameVariable;
    protected GlobalActorHelper m_Helper;
    protected AbstractActor m_GlobalActor;
    protected int m_Counter;
    protected String m_ScreenshotResult;

    @Override
    public String globalInfo() {
        return "Takes a screenshot of a global actor whenever a token passes through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("global", "globalName", new GlobalActorReference("unknown"));
        this.m_OptionManager.add("output-dir", "outputDir", new PlaceholderDirectory("."));
        this.m_OptionManager.add("filename-prefix", "filenamePrefix", "screenshot");
        this.m_OptionManager.add("filename-var", "filenameVariable", new VariableName());
        this.m_OptionManager.add("writer", "writer", new NullWriter());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new GlobalActorHelper();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Counter = 0;
        this.m_InputToken = null;
        this.m_OutputToken = null;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_COUNTER);
        this.pruneBackup(BACKUP_INPUT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_COUNTER, this.m_Counter);
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_COUNTER)) {
            this.m_Counter = (Integer)state.get(BACKUP_COUNTER);
            state.remove(BACKUP_COUNTER);
        }
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public String getQuickInfo() {
        String result;
        String variable = this.getOptionManager().getVariableForProperty("filenameVariable");
        if (variable != null) {
            result = variable;
        } else if (this.m_FilenameVariable != null && this.m_FilenameVariable.getValue().length() > 0) {
            result = "@{" + this.m_FilenameVariable + "}";
        } else {
            variable = this.getOptionManager().getVariableForProperty("output");
            String output = variable == null ? this.m_OutputDir.toString() : variable;
            variable = this.getOptionManager().getVariableForProperty("filenamePrefix");
            String prefix = variable == null ? this.m_FilenamePrefix.toString() : variable;
            if (!(this.getWriter() instanceof NullWriter)) {
                result = output + File.separator + prefix + "XYZ";
                if (this.getWriter().getExtensions().length > 0) {
                    result = result + this.getWriter().getExtensions()[0];
                }
            } else {
                result = output;
            }
        }
        return result;
    }

    public void setGlobalName(GlobalActorReference value) {
        this.m_GlobalName = value;
        this.reset();
    }

    public GlobalActorReference getGlobalName() {
        return this.m_GlobalName;
    }

    public String globalNameTipText() {
        return "The name of the global actor to use.";
    }

    public void setOutputDir(PlaceholderDirectory value) {
        this.m_OutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDir() {
        return this.m_OutputDir;
    }

    public String outputDirTipText() {
        return "The output directory.";
    }

    public void setFilenamePrefix(String value) {
        this.m_FilenamePrefix = value;
        this.reset();
    }

    public String getFilenamePrefix() {
        return this.m_FilenamePrefix;
    }

    public String filenamePrefixTipText() {
        return "The prefix for the filename in case of auto-generation (no path, just name).";
    }

    public void setFilenameVariable(VariableName value) {
        this.m_FilenameVariable = value;
        this.reset();
    }

    public VariableName getFilenameVariable() {
        return this.m_FilenameVariable;
    }

    public String filenameVariableTipText() {
        return "The variable to use for the filename instead of the auto-generated one.";
    }

    public void setWriter(JComponentWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public JComponentWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for generating the graphics output.";
    }

    protected AbstractActor findGlobalActor() {
        return this.m_Helper.findGlobalActorRecursive(this, this.getGlobalName());
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_GlobalActor = this.findGlobalActor();
            if (this.m_GlobalActor == null) {
                result = "Couldn't find global actor '" + this.getGlobalName() + "'!";
            } else if (!(this.m_GlobalActor instanceof ComponentSupplier)) {
                result = "Global actor '" + this.getGlobalName() + "' is not a " + ComponentSupplier.class.getName() + "!";
            } else {
                HashSet<String> variables = this.findVariables(this.m_GlobalActor);
                this.m_DetectedVariables.addAll(variables);
                if (this.m_DetectedVariables.size() > 0) {
                    this.getVariables().addVariableChangeListener(this);
                }
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    protected PlaceholderFile generateFilename() {
        ++this.m_Counter;
        PlaceholderFile result = this.getVariables().has(this.m_FilenameVariable.getValue()) ? new PlaceholderFile(this.getVariables().get(this.m_FilenameVariable.getValue())) : new PlaceholderFile(this.m_OutputDir.getAbsolutePath() + File.separator + FileUtils.createFilename(this.m_FilenamePrefix + this.m_Counter + this.m_Writer.getExtensions()[0], "_"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doExecute() {
        this.m_ScreenshotResult = null;
        final PlaceholderFile filename = this.generateFilename();
        if (!this.m_Headless) {
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AbstractActor abstractActor = GlobalActorScreenshot.this.m_GlobalActor;
                    synchronized (abstractActor) {
                        GlobalActorScreenshot.this.debug("Saving to: " + filename);
                        GlobalActorScreenshot.this.m_Writer.setComponent(((ComponentSupplier)((Object)GlobalActorScreenshot.this.m_GlobalActor)).supplyComponent());
                        GlobalActorScreenshot.this.m_Writer.setFile(filename);
                        try {
                            GlobalActorScreenshot.this.m_Writer.toOutput();
                        }
                        catch (Exception e) {
                            GlobalActorScreenshot.this.m_ScreenshotResult = GlobalActorScreenshot.this.handleException("Failed to generate screenshot ('" + filename + "'): ", e);
                        }
                        GlobalActorScreenshot.this.m_Writer.setComponent(null);
                        AbstractActor abstractActor2 = GlobalActorScreenshot.this.m_Self;
                        synchronized (abstractActor2) {
                            try {
                                GlobalActorScreenshot.this.m_Self.notifyAll();
                            }
                            catch (Exception e) {
                                GlobalActorScreenshot.this.handleException("Failed to notify all", e);
                            }
                        }
                    }
                }
            };
            AbstractActor abstractActor = this.m_Self;
            synchronized (abstractActor) {
                SwingUtilities.invokeLater(run);
                try {
                    this.m_Self.wait();
                }
                catch (Exception e) {
                    this.handleException("Failed to wait", e);
                }
            }
        }
        String result = this.m_ScreenshotResult;
        this.m_ScreenshotResult = null;
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public void wrapUp() {
        this.m_InputToken = null;
        this.m_OutputToken = null;
        super.wrapUp();
    }
}

