/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Properties;
import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.data.id.IDHandler;
import adams.db.LogEntry;
import adams.flow.control.Tee;
import adams.flow.core.Compatibility;
import adams.flow.core.Token;

public class Rejector
extends Tee {
    private static final long serialVersionUID = -5532257363818440415L;
    protected String m_LogSource;

    @Override
    public String globalInfo() {
        return "Rejects data containers with errors attached. The errors get tee-ed off as log entries. Instead of using the full name of the actor as 'source' in the log entries, a custom 'source' value can be supplied.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("log-source", "logSource", "");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_MinimumActiveActors = 0;
    }

    @Override
    public String getQuickInfo() {
        String result = null;
        String variable = this.getOptionManager().getVariableForProperty("logSource");
        if (variable != null) {
            result = variable;
        } else if (this.m_LogSource != null && this.m_LogSource.length() > 0) {
            result = this.m_LogSource;
        }
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    public void setLogSource(String value) {
        this.m_LogSource = value;
        this.reset();
    }

    public String getLogSource() {
        return this.m_LogSource;
    }

    public String logSourceTipText() {
        return "The value to use as 'source' field in the log entries; the actor's full name is used by default if left empty.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{DataContainer.class, NotesHandler.class};
    }

    @Override
    protected String setUpTeeActors() {
        String result = null;
        Compatibility comp = new Compatibility();
        if (!comp.isCompatible(new Class[]{LogEntry.class}, this.m_Actors.accepts())) {
            result = "Tee actors must accept " + LogEntry.class.getName() + "!";
        }
        return result;
    }

    protected boolean hasError(Token token) {
        NotesHandler handler = (NotesHandler)token.getPayload();
        return handler.getNotes().hasError();
    }

    @Override
    protected Token createTeeToken(Token token) {
        LogEntry log = new LogEntry();
        NotesHandler handler = (NotesHandler)token.getPayload();
        Properties props = new Properties();
        if (handler instanceof DatabaseIDHandler) {
            props.setInteger("DB-ID", ((DatabaseIDHandler)((Object)handler)).getDatabaseID());
            log.setDatabaseID(((DatabaseIDHandler)((Object)handler)).getDatabaseID());
        }
        if (handler instanceof IDHandler) {
            props.setString("ID", ((IDHandler)((Object)handler)).getID());
        }
        props.setProperty("Errors", handler.getNotes().getErrors().toString());
        log.setType("Rejection");
        if (this.m_LogSource.length() == 0) {
            log.setSource(this.getFullName());
        } else {
            log.setSource(this.m_LogSource);
        }
        log.setStatus("New");
        log.setMessage(props);
        return new Token(log);
    }

    @Override
    protected boolean canProcessInput(Token token) {
        return super.canProcessInput(token) && token.getPayload() instanceof NotesHandler && this.hasError(token);
    }

    @Override
    protected String doExecute() {
        String result = super.doExecute();
        if (this.hasError(this.m_OutputToken)) {
            this.m_OutputToken = null;
        }
        return result;
    }
}

