/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.CloneHandler;
import adams.core.LRUCache;
import adams.flow.control.StorageName;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class Storage
implements CloneHandler<Storage> {
    public static final String CHARS = "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ-0123456789:.";
    protected Hashtable<String, Object> m_Data = new Hashtable();
    protected Hashtable<String, LRUCache<String, Object>> m_Caches = new Hashtable();

    public void clear() {
        this.m_Data.clear();
        this.m_Caches.clear();
    }

    public Enumeration<String> caches() {
        Vector<String> result = new Vector<String>(this.m_Caches.keySet());
        Collections.sort(result);
        return result.elements();
    }

    public void addCache(String name, int size) {
        this.m_Caches.put(name, new LRUCache(size));
    }

    public Object put(StorageName name, Object value) {
        return this.m_Data.put(name.getValue(), value);
    }

    public void put(String cache, StorageName name, Object value) {
        if (this.m_Caches.containsKey(cache)) {
            this.m_Caches.get(cache).put(name.getValue(), value);
        }
    }

    public boolean has(StorageName name) {
        return this.m_Data.containsKey(name.getValue());
    }

    public boolean has(String cache, StorageName name) {
        if (this.m_Caches.containsKey(cache)) {
            return this.m_Caches.get(cache).contains(name.getValue());
        }
        return false;
    }

    public Object get(StorageName name) {
        return this.m_Data.get(name.getValue());
    }

    public Object get(String cache, StorageName name) {
        if (this.m_Caches.containsKey(cache)) {
            return this.m_Caches.get(cache).get(name.getValue());
        }
        return null;
    }

    public Object remove(StorageName name) {
        return this.m_Data.remove(name.getValue());
    }

    public Object remove(String cache, StorageName name) {
        if (this.m_Caches.containsKey(cache)) {
            return this.m_Caches.get(cache).remove(name.getValue());
        }
        return null;
    }

    public int size() {
        return this.m_Data.size();
    }

    public int size(String cache) {
        if (this.m_Caches.containsKey(cache)) {
            return this.m_Caches.get(cache).sizeUsed();
        }
        return 0;
    }

    public Set<StorageName> keySet() {
        HashSet<StorageName> result = new HashSet<StorageName>();
        Set<String> set = this.m_Data.keySet();
        for (String key : set) {
            result.add(new StorageName(key));
        }
        return result;
    }

    public Set<StorageName> keySet(String cache) {
        HashSet<StorageName> result = new HashSet<StorageName>();
        if (this.m_Caches.containsKey(cache)) {
            Set<String> set = this.m_Caches.get(cache).keySet();
            for (String key : set) {
                result.add(new StorageName(key));
            }
        }
        return result;
    }

    @Override
    public Storage getClone() {
        Storage result = new Storage();
        for (String key : this.m_Caches.keySet()) {
            Object cache = this.m_Caches.get(key).getClone();
            result.m_Caches.put(key, (LRUCache<String, Object>)cache);
        }
        result.m_Data = (Hashtable)this.m_Data.clone();
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Regular:\n");
        result.append(this.m_Data.toString());
        Enumeration<String> names = this.caches();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            result.append("\n");
            result.append("Cache '" + name + "':\n");
            result.append(this.m_Caches.get(name).toString());
        }
        return result.toString();
    }

    public static boolean isValidName(String s) {
        boolean result;
        String name = s;
        boolean bl = result = name.length() > 0;
        if (result) {
            result = (name = name.replaceAll("\\w", "").replace("-", "").replace(":", "").replace(".", "")).length() == 0;
        }
        return result;
    }

    public static String toValidName(String s) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char chr = s.charAt(i);
            if (chr >= '0' && chr <= '9') {
                result.append(chr);
                continue;
            }
            if (chr >= 'a' && chr <= 'z') {
                result.append(chr);
                continue;
            }
            if (chr >= 'A' && chr <= 'Z') {
                result.append(chr);
                continue;
            }
            if (chr == '_') {
                result.append(chr);
                continue;
            }
            if (chr == '-') {
                result.append(chr);
                continue;
            }
            if (chr == ':') {
                result.append(chr);
                continue;
            }
            if (chr == '.') {
                result.append(chr);
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }
}

