/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.Sequence;
import adams.flow.control.StorageName;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class StorageValueSequence
extends Sequence
implements OutputProducer {
    private static final long serialVersionUID = -8578140700965630555L;
    public static final String BACKUP_HASOUTPUT = "hasoutput";
    protected StorageName m_StorageName;
    protected boolean m_HasOutput;

    @Override
    public String globalInfo() {
        return "After executing a sequence of actors, the stored item is forwarded in the flow. This actor is useful if a storage item is modified in a series of Triggers or Tees, but still needs to be forwarded in the flow.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored value to forward in the flow.";
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("storageName");
        String result = variable != null ? variable : this.m_StorageName.getValue();
        if (super.getQuickInfo() != null) {
            result = result + ", " + super.getQuickInfo();
        }
        return result;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_HASOUTPUT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_HASOUTPUT, this.m_HasOutput);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_HASOUTPUT)) {
            this.m_HasOutput = (Boolean)state.get(BACKUP_HASOUTPUT);
            state.remove(BACKUP_HASOUTPUT);
        }
        super.restoreState(state);
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = super.doExecute();
        if (result == null) {
            this.m_HasOutput = this.getStorageHandler().getStorage().has(this.m_StorageName);
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_HasOutput;
    }

    @Override
    public Token output() {
        Token result = new Token(this.getStorageHandler().getStorage().get(this.m_StorageName));
        this.m_HasOutput = false;
        return result;
    }

    @Override
    public void wrapUp() {
        this.m_HasOutput = false;
        super.wrapUp();
    }
}

