/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.AbstractTee;
import adams.flow.control.Tee;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;

public class Trigger
extends AbstractTee {
    private static final long serialVersionUID = 4690934665757923783L;

    @Override
    public String globalInfo() {
        return "Executes the subs-actors whenever a token gets passed through. In contrast to the " + Tee.class.getName() + " actor, it doesn't feed " + "the sub-actors with the current token.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Actors.setAllowStandalones(true);
        this.m_Actors.setAllowSource(true);
    }

    @Override
    protected String setUpTeeActors() {
        return ActorUtils.checkForSource(this.getActors());
    }

    public boolean canContainStandalones() {
        return true;
    }

    @Override
    protected String checkTeeActor(int index, AbstractActor actor) {
        return null;
    }

    @Override
    protected String checkTeeActors(AbstractActor[] actors) {
        return ActorUtils.checkForSource(actors);
    }

    @Override
    protected String processInput(Token token) {
        String result;
        try {
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preExecute(this);
            }
            result = this.m_Actors.execute();
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postExecute(this);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to trigger: ", e);
        }
        return result;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.SEQUENTIAL, false);
    }
}

