/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.ClassLocator;
import adams.core.VariablesHandler;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.control.AbstractControlActor;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorUtils;
import adams.flow.core.FixedNameActorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import java.lang.reflect.Array;
import java.util.Hashtable;

public class TryCatch
extends AbstractControlActor
implements InputConsumer,
OutputProducer,
FixedNameActorHandler {
    private static final long serialVersionUID = -9029393233616734995L;
    protected AbstractActor m_Try;
    protected AbstractActor m_Catch;
    public static final String BACKUP_INPUT = "input";
    public static final String NAME_TRY = "try";
    public static final String NAME_CATCH = "catch";
    protected transient Token m_InputToken;
    protected String m_ErrorOccurred;

    @Override
    public String globalInfo() {
        return "Safe-guards the execution of the 'try' sequence of actors. In case of an error, the 'catch' sequence is executed to generate output instead.\nThis works similar to the Java try-catch-block. Allowing the flow to recover from unexpected errors and, for instance, return default values.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Try = this.getDefaultTry();
        this.m_Catch = this.getDefaultCatch();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(NAME_TRY, NAME_TRY, this.getDefaultTry());
        this.m_OptionManager.add(NAME_CATCH, NAME_CATCH, this.getDefaultCatch());
    }

    protected AbstractActor getDefaultTry() {
        SubProcess result = new SubProcess();
        result.setName(NAME_TRY);
        return result;
    }

    public void setTry(AbstractActor value) {
        if (ActorUtils.isTransformer(value)) {
            this.m_Try = value;
            this.m_Try.setName(NAME_TRY);
            this.updateParent();
            this.reset();
        } else {
            this.getSystemErr().println("'try' actor(s) must be a transformer, " + value.getClass().getName() + " is not!");
        }
    }

    public AbstractActor getTry() {
        return this.m_Try;
    }

    public String tryTipText() {
        return "The 'try' branch which is attempted to be executed.";
    }

    protected AbstractActor getDefaultCatch() {
        SubProcess result = new SubProcess();
        result.setName(NAME_CATCH);
        return result;
    }

    public void setCatch(AbstractActor value) {
        if (ActorUtils.isSource(value) || ActorUtils.isTransformer(value)) {
            this.m_Catch = value;
            this.m_Catch.setName(NAME_CATCH);
            this.updateParent();
            this.reset();
        } else {
            this.getSystemErr().println("'catch' actor(s) must be a source or transformer, " + value.getClass().getName() + " is not!");
        }
    }

    public AbstractActor getCatch() {
        return this.m_Catch;
    }

    public String catchTipText() {
        return "The 'catch' branch which gets executed if the 'try' branch fails.";
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.UNDEFINED, true);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public AbstractActor get(int index) {
        if (index == 0) {
            return this.m_Try;
        }
        if (index == 1) {
            return this.m_Catch;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        if (index == 0) {
            this.setTry(actor);
        } else if (index == 1) {
            this.setCatch(actor);
        } else {
            throw new IllegalArgumentException("Illegal index: " + index);
        }
    }

    @Override
    public int indexOf(String actor) {
        if (this.m_Try.getName().equals(actor)) {
            return 0;
        }
        if (this.m_Catch.getName().equals(actor)) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getFixedName(int index) {
        if (index == 0) {
            return NAME_TRY;
        }
        if (index == 1) {
            return NAME_CATCH;
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    @Override
    public Class[] accepts() {
        return ((InputConsumer)((Object)this.m_Try)).accepts();
    }

    @Override
    public void handleError(AbstractActor source, String type, String msg) {
        this.m_ErrorOccurred = source.getFullName() + "/" + type + ": " + msg;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_OptionManager.traverse(new OptionTraverser(){

                @Override
                public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                    if (ClassLocator.isSubclass(AbstractActor.class, option.getBaseClass())) {
                        Object current = option.getCurrentValue();
                        if (option.isMultiple()) {
                            for (int i = 0; i < Array.getLength(current); ++i) {
                                ((AbstractActor)Array.get(current, i)).setErrorHandler(TryCatch.this);
                            }
                        } else {
                            ((AbstractActor)current).setErrorHandler(TryCatch.this);
                        }
                    }
                }

                @Override
                public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
                }

                @Override
                public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
                }

                @Override
                public boolean canRecurse(Class cls) {
                    return !ClassLocator.hasInterface(VariablesHandler.class, cls);
                }

                @Override
                public boolean canRecurse(Object obj) {
                    return this.canRecurse(obj.getClass());
                }
            });
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.m_ErrorOccurred = null;
        String msg = "Failed to execute 'try' branch: ";
        try {
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preInput(this.m_Try, this.m_InputToken);
            }
            ((InputConsumer)((Object)this.m_Try)).input(this.m_InputToken);
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postInput(this.m_Try);
            }
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preExecute(this.m_Try);
            }
            result = this.m_Try.execute();
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postExecute(this.m_Try);
            }
            if (result != null) {
                this.m_ErrorOccurred = msg + result;
            }
        }
        catch (Exception e) {
            this.m_ErrorOccurred = this.handleException(msg, e);
        }
        if (this.m_ErrorOccurred != null) {
            if (ActorUtils.isTransformer(this.m_Catch)) {
                if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                    this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preInput(this.m_Catch, this.m_InputToken);
                }
                ((InputConsumer)((Object)this.m_Catch)).input(this.m_InputToken);
                if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                    this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postInput(this.m_Catch);
                }
            }
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preExecute(this.m_Catch);
            }
            result = this.m_Catch.execute();
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postExecute(this.m_Catch);
            }
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return ((OutputProducer)((Object)this.m_Try)).generates();
    }

    @Override
    public boolean hasPendingOutput() {
        if (this.m_ErrorOccurred != null) {
            return ((OutputProducer)((Object)this.m_Catch)).hasPendingOutput();
        }
        return ((OutputProducer)((Object)this.m_Try)).hasPendingOutput();
    }

    @Override
    public Token output() {
        Token result;
        if (this.m_ErrorOccurred != null) {
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preOutput(this.m_Catch);
            }
            result = ((OutputProducer)((Object)this.m_Catch)).output();
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postOutput(this.m_Catch, result);
            }
        } else {
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().preOutput(this.m_Try);
            }
            result = ((OutputProducer)((Object)this.m_Try)).output();
            if (this.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                this.getFlowExecutionListeningSupporter().getFlowExecutionListener().postOutput(this.m_Try, result);
            }
        }
        return result;
    }
}

