/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.NamedCounter;
import adams.data.statistics.InformativeStatistic;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class ActorStatistic
implements InformativeStatistic {
    public static String COUNT_ACTORS = "Actors";
    public static String COUNT_CONTROLACTORS = "Control actors";
    public static String COUNT_STANDALONES = "Standalones";
    public static String COUNT_SOURCES = "Sources";
    public static String COUNT_TRANSFORMERS = "Transformers";
    public static String COUNT_SINKS = "Sinks";
    protected NamedCounter m_TypeStatistics = new NamedCounter();
    protected NamedCounter m_ClassStatistics = new NamedCounter();
    protected AbstractActor m_Actor = null;

    public ActorStatistic() {
    }

    public ActorStatistic(AbstractActor actor) {
        this();
        this.setActor(actor);
    }

    public void setActor(AbstractActor value) {
        this.m_Actor = value;
        this.calculate();
    }

    public AbstractActor getActor() {
        return this.m_Actor;
    }

    protected void update(AbstractActor actor) {
        this.m_TypeStatistics.next(COUNT_ACTORS);
        if (ActorUtils.isControlActor(actor)) {
            this.m_TypeStatistics.next(COUNT_CONTROLACTORS);
        }
        if (ActorUtils.isStandalone(actor)) {
            this.m_TypeStatistics.next(COUNT_STANDALONES);
        }
        if (ActorUtils.isSource(actor)) {
            this.m_TypeStatistics.next(COUNT_SOURCES);
        }
        if (ActorUtils.isTransformer(actor)) {
            this.m_TypeStatistics.next(COUNT_TRANSFORMERS);
        }
        if (ActorUtils.isSink(actor)) {
            this.m_TypeStatistics.next(COUNT_SINKS);
        }
        this.m_ClassStatistics.next(actor.getClass().getName());
    }

    protected void calculate() {
        this.m_TypeStatistics.clear();
        this.m_TypeStatistics.clear(COUNT_ACTORS);
        this.m_TypeStatistics.clear(COUNT_CONTROLACTORS);
        this.m_TypeStatistics.clear(COUNT_STANDALONES);
        this.m_TypeStatistics.clear(COUNT_SOURCES);
        this.m_TypeStatistics.clear(COUNT_TRANSFORMERS);
        this.m_TypeStatistics.clear(COUNT_SINKS);
        this.m_ClassStatistics.clear();
        if (this.m_Actor == null) {
            return;
        }
        List<AbstractActor> actors = ActorUtils.enumerate(this.getActor());
        this.update(this.m_Actor);
        for (AbstractActor actor : actors) {
            this.update(actor);
        }
    }

    @Override
    public String getStatisticDescription() {
        if (this.m_Actor == null) {
            return "Statistics";
        }
        return this.m_Actor.getName();
    }

    @Override
    public Enumeration<String> statisticNames() {
        Vector<String> result = new Vector<String>(this.m_TypeStatistics.nameSet());
        Collections.sort(result);
        Vector<String> classes = new Vector<String>(this.m_ClassStatistics.nameSet());
        Collections.sort(classes);
        result.addAll(classes);
        return result.elements();
    }

    @Override
    public double getStatistic(String name) {
        if (this.m_TypeStatistics.has(name)) {
            return this.m_TypeStatistics.current(name);
        }
        return this.m_ClassStatistics.current(name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getStatisticDescription());
        result.append("\n");
        Enumeration<String> names = this.statisticNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            result.append(name + ": " + this.getStatistic(name));
            result.append("\n");
        }
        return result.toString();
    }
}

