/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ConsoleObject;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractExternalActor;
import adams.flow.core.AbstractGlobalActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorHandler;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.sink.GlobalSink;
import adams.flow.source.GlobalSource;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.GlobalTransformer;
import java.util.List;

public class GlobalActorHelper
extends ConsoleObject {
    private static final long serialVersionUID = -763479272812116920L;

    public AbstractActor findGlobalActor(ActorHandler group, GlobalActorReference name) {
        AbstractActor result = null;
        for (int i = 0; i < group.size(); ++i) {
            AbstractExternalActor external;
            if (group.get(i) instanceof GlobalActorHandler) {
                GlobalActorHandler global = (GlobalActorHandler)((Object)group.get(i));
                int index = global.indexOf(name.toString());
                if (index <= -1) continue;
                result = global.get(index);
                break;
            }
            if (group.get(i) instanceof AbstractExternalActor && (external = (AbstractExternalActor)group.get(i)).getExternalActor() instanceof ActorHandler && (result = this.findGlobalActor((ActorHandler)((Object)external.getExternalActor()), name)) != null) break;
        }
        return result;
    }

    public AbstractActor findGlobalActor(AbstractActor root, GlobalActorReference name) {
        AbstractActor result = null;
        if (root == null) {
            this.getSystemErr().println("No root container found!");
        } else if (!(root instanceof AbstractDirectedControlActor)) {
            this.getSystemErr().println("Root is not a container ('" + root.getFullName() + "'/" + root.getClass().getName() + ")!");
            root = null;
        }
        if (root != null) {
            result = this.findGlobalActor((ActorHandler)((Object)root), name);
        }
        return result;
    }

    public AbstractActor findGlobalActorRecursive(AbstractActor actor, GlobalActorReference name) {
        AbstractActor result = null;
        List<ActorHandler> handlers = ActorUtils.findActorHandlers(actor, true);
        for (int i = 0; i < handlers.size() && (result = this.findGlobalActor(handlers.get(i), name)) == null; ++i) {
        }
        return result;
    }

    protected static Object getSetup(Class cls, GlobalActorReference globalName, AbstractActor start, AbstractGlobalActor global) {
        Object result = null;
        global.setGlobalName(globalName);
        global.setParent(start.getParent());
        if (global.setUp() == null) {
            global.execute();
            Token token = ((OutputProducer)((Object)global)).output();
            if (token != null) {
                result = token.getPayload();
                if (cls != null && !cls.isInstance(result)) {
                    result = null;
                }
                AbstractActor actor = global.getGlobalActor();
                global.wrapUp();
                global.cleanUp();
                if (actor != null) {
                    actor.setUp();
                }
            }
        }
        return result;
    }

    public static Object getSetup(Class cls, GlobalActorReference globalName, AbstractActor start) {
        Object result = GlobalActorHelper.getSetupFromSource(cls, globalName, start);
        if (result == null) {
            result = GlobalActorHelper.getSetupFromTransformer(cls, globalName, start);
        }
        return result;
    }

    public static Object getSetupFromSource(Class cls, GlobalActorReference globalName, AbstractActor start) {
        return GlobalActorHelper.getSetup(cls, globalName, start, new GlobalSource());
    }

    public static Object getSetupFromTransformer(Class cls, GlobalActorReference globalName, AbstractActor start) {
        return GlobalActorHelper.getSetup(cls, globalName, start, new GlobalTransformer());
    }

    public static List<AbstractActor> findAllGlobalActors(AbstractActor flow) {
        return ActorUtils.enumerate(flow.getRoot(), new Class[]{GlobalActors.class});
    }

    public static GlobalActors createGlobalActors(AbstractActor actor, boolean insert) {
        GlobalActors result = null;
        List<ActorHandler> global = ActorUtils.findActorHandlers(actor, true, true);
        int i = 0;
        while (i < global.size()) {
            if (global.get(i) instanceof GlobalActors) {
                ++i;
                continue;
            }
            global.remove(i);
        }
        if (global.size() == 0 && insert) {
            AbstractActor root = actor.getRoot();
            if (!((ActorHandler)((Object)root)).getActorHandlerInfo().canContainStandalones()) {
                System.err.println("Root actor '" + root.getName() + "' cannot contain standalones!");
                return null;
            }
            result = new GlobalActors();
            if (root instanceof MutableActorHandler) {
                ((MutableActorHandler)((Object)root)).add(0, result);
            } else {
                System.err.println("Cannot add GlobalActors container to root actor!");
            }
        } else {
            result = (GlobalActors)global.get(global.size() - 1);
        }
        return result;
    }

    public static AbstractActor createGlobalActor(AbstractActor actor) {
        GlobalActors globalActors = GlobalActorHelper.createGlobalActors(actor, true);
        if (globalActors == null) {
            return null;
        }
        int index = actor.index();
        ActorHandler parent = (ActorHandler)((Object)actor.getParent());
        globalActors.add(actor);
        AbstractGlobalActor replacement = null;
        if (ActorUtils.isSource(actor)) {
            replacement = new GlobalSource();
        } else if (ActorUtils.isTransformer(actor)) {
            replacement = new GlobalTransformer();
        } else if (ActorUtils.isSink(actor)) {
            replacement = new GlobalSink();
        }
        replacement.setGlobalName(new GlobalActorReference(actor.getName()));
        parent.set(index, replacement);
        return replacement;
    }
}

