/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.flow.core.AbstractPropertyValueConverter;
import adams.flow.core.DefaultPropertyValueConverter;
import adams.gui.goe.PropertyPath;
import java.util.ArrayList;
import java.util.List;

public class PropertyHelper {
    protected static List<AbstractPropertyValueConverter> m_Converters;
    protected static AbstractPropertyValueConverter m_DefaultConverter;

    protected static synchronized void initialize() {
        if (m_Converters == null) {
            String[] classnames;
            m_DefaultConverter = new DefaultPropertyValueConverter();
            ArrayList<AbstractPropertyValueConverter> converters = new ArrayList<AbstractPropertyValueConverter>();
            for (String classname : classnames = AbstractPropertyValueConverter.getConverters()) {
                if (classname.equals(m_DefaultConverter.getClass().getName())) continue;
                try {
                    AbstractPropertyValueConverter converter = (AbstractPropertyValueConverter)Class.forName(classname).newInstance();
                    converters.add(converter);
                }
                catch (Exception e) {
                    System.err.println("Failed to instantiate property value converter: " + classname);
                    e.printStackTrace();
                }
            }
            m_Converters = converters;
        }
    }

    public static Object convertVariableValue(PropertyPath.PropertyContainer cont, String value) {
        Object result = null;
        Class<?> cls = cont.getReadMethod().getReturnType();
        PropertyHelper.initialize();
        if (m_DefaultConverter.handles(cls)) {
            try {
                result = m_DefaultConverter.convert(cls, value);
            }
            catch (Exception e) {
                System.err.println("Failed to convert '" + value + "' with " + m_DefaultConverter.getClass().getName() + "!");
                e.printStackTrace();
            }
        }
        if (result == null) {
            for (AbstractPropertyValueConverter converter : m_Converters) {
                if (!converter.handles(cls)) continue;
                try {
                    result = converter.convert(cls, value);
                }
                catch (Exception e) {
                    System.err.println("Failed to convert '" + value + "' with " + converter.getClass().getName() + "!");
                    e.printStackTrace();
                }
                if (result == null) continue;
                break;
            }
        }
        if (result == null) {
            System.err.println("Class " + cls.getName() + " not (yet) supported for setting property!");
        }
        return result;
    }
}

