/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.flow.core.Actor;
import adams.flow.execution.AbstractTimedFlowExecutionListenerWithTable;
import adams.gui.core.HashtableTableModel;
import java.util.Hashtable;
import javax.swing.table.TableModel;

public class ExecutionCounter
extends AbstractTimedFlowExecutionListenerWithTable {
    private static final long serialVersionUID = -4978449149708112013L;
    protected Hashtable<String, Integer> m_Counts;

    @Override
    public String globalInfo() {
        return "Counts how often an actor was executed.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Counts = new Hashtable();
    }

    @Override
    protected int getDefaultUpdateInterval() {
        return 100;
    }

    @Override
    public String updateIntervalTipText() {
        return "The update interval after which the GUI gets refreshed.";
    }

    @Override
    public String getListenerTitle() {
        return "Execution counter";
    }

    @Override
    protected TableModel createTableModel() {
        return new HashtableTableModel((Hashtable)this.m_Counts.clone(), new String[]{"Actor", "Count"});
    }

    @Override
    public void startListening() {
        super.startListening();
        this.m_Counts.clear();
    }

    @Override
    public void postExecute(Actor actor) {
        super.postExecute(actor);
        String key = actor.getFullName();
        int count = !this.m_Counts.containsKey(key) ? 0 : this.m_Counts.get(key);
        this.m_Counts.put(key, ++count);
        this.incCounter();
    }

    @Override
    public void finishListening() {
        super.finishListening();
        if (this.isDebugOn()) {
            this.debug(this.m_Counts.toString());
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_Counts != null) {
            this.m_Counts.clear();
            this.m_Counts = null;
        }
    }
}

