/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.execution.AbstractTimedFlowExecutionListenerWithTable;
import adams.gui.core.HashtableTableModel;
import java.util.Hashtable;
import javax.swing.table.TableModel;

public class Time
extends AbstractTimedFlowExecutionListenerWithTable {
    private static final long serialVersionUID = -6155792276833652477L;
    public static final String SUFFIX_INPUT = ".input";
    public static final String SUFFIX_EXECUTE = ".execute";
    public static final String SUFFIX_OUTPUT = ".output";
    protected Hashtable<String, Long> m_Start;
    protected Hashtable<String, Long> m_Overall;

    @Override
    public String globalInfo() {
        return "Shows how much time actors are taking in their method calls (gets accumulated).";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Start = new Hashtable();
        this.m_Overall = new Hashtable();
    }

    @Override
    public String updateIntervalTipText() {
        return "The update interval (= number of method executions) after which the GUI gets refreshed.";
    }

    @Override
    public String getListenerTitle() {
        return "Time";
    }

    @Override
    public void startListening() {
        super.startListening();
        this.m_Overall.clear();
        this.m_Start.clear();
    }

    protected void addStart(String key) {
        this.m_Start.put(key, System.currentTimeMillis());
    }

    protected void addDuration(String key) {
        if (this.m_Start.containsKey(key)) {
            long current = System.currentTimeMillis();
            long overall = 0L;
            long start = this.m_Start.get(key);
            if (this.m_Overall.containsKey(key)) {
                overall = this.m_Overall.get(key);
            }
            this.m_Overall.put(key, overall += current - start);
            this.m_Start.remove(key);
        }
        this.incCounter();
    }

    @Override
    protected int getDefaultUpdateInterval() {
        return 100;
    }

    @Override
    protected TableModel createTableModel() {
        return new HashtableTableModel((Hashtable)this.m_Overall.clone(), new String[]{"Actor", "Time in msec"});
    }

    @Override
    public void preInput(Actor actor, Token token) {
        this.addStart(actor.getFullName() + SUFFIX_INPUT);
    }

    @Override
    public void postInput(Actor actor) {
        this.addDuration(actor.getFullName() + SUFFIX_INPUT);
    }

    @Override
    public void preExecute(Actor actor) {
        this.addStart(actor.getFullName() + SUFFIX_EXECUTE);
    }

    @Override
    public void postExecute(Actor actor) {
        this.addDuration(actor.getFullName() + SUFFIX_EXECUTE);
    }

    @Override
    public void preOutput(Actor actor) {
        this.addStart(actor.getFullName() + SUFFIX_OUTPUT);
    }

    @Override
    public void postOutput(Actor actor, Token token) {
        this.addDuration(actor.getFullName() + SUFFIX_OUTPUT);
    }

    @Override
    public void finishListening() {
        super.finishListening();
        if (this.isDebugOn()) {
            this.debug(this.m_Overall.toString());
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_Overall != null) {
            this.m_Overall.clear();
            this.m_Overall = null;
            this.m_Start.clear();
            this.m_Start = null;
        }
    }
}

